/// <reference types="react" />

import { Atom } from '@tldraw/state';
import { atom } from '@tldraw/state';
import { BoxModel } from '@tldraw/tlschema';
import { ComponentType } from 'react';
import { Computed } from '@tldraw/state';
import { computed } from '@tldraw/state';
import { Dispatch } from 'react';
import { EffectScheduler } from '@tldraw/state';
import { EmbedDefinition } from '@tldraw/tlschema';
import { EMPTY_ARRAY } from '@tldraw/state';
import EventEmitter from 'eventemitter3';
import { HistoryEntry } from '@tldraw/store';
import { IndexKey } from '@tldraw/utils';
import { JsonObject } from '@tldraw/utils';
import { JSX as JSX_2 } from 'react/jsx-runtime';
import { LegacyMigrations } from '@tldraw/store';
import { MigrationSequence } from '@tldraw/store';
import { NamedExoticComponent } from 'react';
import { PerformanceTracker } from '@tldraw/utils';
import { PointerEventHandler } from 'react';
import { react } from '@tldraw/state';
import { default as React_2 } from 'react';
import * as React_3 from 'react';
import { ReactElement } from 'react';
import { ReactNode } from 'react';
import { RecordProps } from '@tldraw/tlschema';
import { RecordsDiff } from '@tldraw/store';
import { SerializedSchema } from '@tldraw/store';
import { SerializedStore } from '@tldraw/store';
import { SetStateAction } from 'react';
import { Signal } from '@tldraw/state';
import { Store } from '@tldraw/store';
import { StoreSchema } from '@tldraw/store';
import { StoreSideEffects } from '@tldraw/store';
import { StyleProp } from '@tldraw/tlschema';
import { StylePropValue } from '@tldraw/tlschema';
import { Timers } from '@tldraw/utils';
import { TLAsset } from '@tldraw/tlschema';
import { TLAssetId } from '@tldraw/tlschema';
import { TLAssetPartial } from '@tldraw/tlschema';
import { TLAssetStore } from '@tldraw/tlschema';
import { TLBaseShape } from '@tldraw/tlschema';
import { TLBinding } from '@tldraw/tlschema';
import { TLBindingCreate } from '@tldraw/tlschema';
import { TLBindingId } from '@tldraw/tlschema';
import { TLBindingUpdate } from '@tldraw/tlschema';
import { TLBookmarkAsset } from '@tldraw/tlschema';
import { TLCamera } from '@tldraw/tlschema';
import { TLCursor } from '@tldraw/tlschema';
import { TLCursorType } from '@tldraw/tlschema';
import { TLDefaultHorizontalAlignStyle } from '@tldraw/tlschema';
import { TLDocument } from '@tldraw/tlschema';
import { TLGroupShape } from '@tldraw/tlschema';
import { TLHandle } from '@tldraw/tlschema';
import { TLImageAsset } from '@tldraw/tlschema';
import { TLInstance } from '@tldraw/tlschema';
import { TLInstancePageState } from '@tldraw/tlschema';
import { TLInstancePresence } from '@tldraw/tlschema';
import { TLPage } from '@tldraw/tlschema';
import { TLPageId } from '@tldraw/tlschema';
import { TLParentId } from '@tldraw/tlschema';
import { TLPropsMigrations } from '@tldraw/tlschema';
import { TLRecord } from '@tldraw/tlschema';
import { TLScribble } from '@tldraw/tlschema';
import { TLShape } from '@tldraw/tlschema';
import { TLShapeId } from '@tldraw/tlschema';
import { TLShapePartial } from '@tldraw/tlschema';
import { TLStore } from '@tldraw/tlschema';
import { TLStoreProps } from '@tldraw/tlschema';
import { TLStoreSnapshot } from '@tldraw/tlschema';
import { TLUnknownBinding } from '@tldraw/tlschema';
import { TLUnknownShape } from '@tldraw/tlschema';
import { TLVideoAsset } from '@tldraw/tlschema';
import { track } from '@tldraw/state-react';
import { transact } from '@tldraw/state';
import { transaction } from '@tldraw/state';
import { UnknownRecord } from '@tldraw/store';
import { useComputed } from '@tldraw/state-react';
import { useQuickReactor } from '@tldraw/state-react';
import { useReactor } from '@tldraw/state-react';
import { useStateTracking } from '@tldraw/state-react';
import { useValue } from '@tldraw/state-react';
import { VecModel } from '@tldraw/tlschema';
import { whyAmIRunning } from '@tldraw/state';

/**
 * Get the angle of a point on an arc.
 * @param fromAngle - The angle from center to arc's start point (A) on the circle
 * @param toAngle - The angle from center to arc's end point (B) on the circle
 * @param direction - The direction of the arc (1 = counter-clockwise, -1 = clockwise)
 * @returns The distance in radians between the two angles according to the direction
 * @public
 */
export declare function angleDistance(fromAngle: number, toAngle: number, direction: number): number;

/* Excluded from this release type: applyRotationToSnapshotShapes */

/**
 * Whether two numbers numbers a and b are approximately equal.
 *
 * @param a - The first point.
 * @param b - The second point.
 * @public
 */
export declare function approximately(a: number, b: number, precision?: number): boolean;

/** @public */
export declare class Arc2d extends Geometry2d {
    _center: Vec;
    radius: number;
    start: Vec;
    end: Vec;
    largeArcFlag: number;
    sweepFlag: number;
    measure: number;
    angleStart: number;
    angleEnd: number;
    constructor(config: Omit<Geometry2dOptions, 'isClosed' | 'isFilled'> & {
        center: Vec;
        end: Vec;
        largeArcFlag: number;
        start: Vec;
        sweepFlag: number;
    });
    nearestPoint(point: Vec): Vec;
    hitTestLineSegment(A: Vec, B: Vec): boolean;
    getVertices(): Vec[];
    getSvgPathData(first?: boolean): string;
    getLength(): number;
}

/**
 * Checks whether two angles are approximately at right-angles or parallel to each other
 *
 * @param a - Angle a (radians)
 * @param b - Angle b (radians)
 * @returns True iff the angles are approximately at right-angles or parallel to each other
 * @public
 */
export declare function areAnglesCompatible(a: number, b: number): boolean;

export { Atom }

export { atom }

/** @public */
export declare function average(A: VecLike, B: VecLike): string;

/** @public */
export declare abstract class BaseBoxShapeTool extends StateNode {
    static id: string;
    static initial: string;
    static children: () => TLStateNodeConstructor[];
    abstract shapeType: string;
    onCreate?: (_shape: null | TLShape) => null | void;
}

/** @public */
export declare abstract class BaseBoxShapeUtil<Shape extends TLBaseBoxShape> extends ShapeUtil<Shape> {
    getGeometry(shape: Shape): Geometry2d;
    onResize: TLOnResizeHandler<any>;
    getHandleSnapGeometry(shape: Shape): HandleSnapGeometry;
    getInterpolatedProps(startShape: Shape, endShape: Shape, t: number): Shape['props'];
}

/**
 * Options passed to {@link BindingUtil.onBeforeChange} and {@link BindingUtil.onAfterChange},
 * describing the data associated with a binding being changed.
 *
 * @public
 */
export declare interface BindingOnChangeOptions<Binding extends TLUnknownBinding> {
    /** The binding record before the change is made. */
    bindingBefore: Binding;
    /** The binding record after the change is made. */
    bindingAfter: Binding;
}

/**
 * Options passed to {@link BindingUtil.onBeforeCreate} and {@link BindingUtil.onAfterCreate},
 * describing a the creating a binding.
 *
 * @public
 */
export declare interface BindingOnCreateOptions<Binding extends TLUnknownBinding> {
    /** The binding being created. */
    binding: Binding;
}

/**
 * Options passed to {@link BindingUtil.onBeforeDelete} and {@link BindingUtil.onAfterDelete},
 * describing a binding being deleted.
 *
 * @public
 */
export declare interface BindingOnDeleteOptions<Binding extends TLUnknownBinding> {
    /** The binding being deleted. */
    binding: Binding;
}

/**
 * Options passed to {@link BindingUtil.onAfterChangeFromShape} and
 * {@link BindingUtil.onAfterChangeToShape}, describing a bound shape being changed.
 *
 * @public
 */
export declare interface BindingOnShapeChangeOptions<Binding extends TLUnknownBinding> {
    /** The binding record linking these two shapes. */
    binding: Binding;
    /** The shape record before the change is made. */
    shapeBefore: TLShape;
    /** The shape record after the change is made. */
    shapeAfter: TLShape;
}

/**
 * Options passed to {@link BindingUtil.onBeforeDeleteFromShape} and
 * {@link BindingUtil.onBeforeDeleteToShape}, describing a bound shape that is about to be deleted.
 *
 * See {@link BindingOnShapeIsolateOptions} for discussion on when to use the delete vs. the isolate
 * callbacks.
 *
 * @public
 */
export declare interface BindingOnShapeDeleteOptions<Binding extends TLUnknownBinding> {
    /** The binding record that refers to the shape in question. */
    binding: Binding;
    /** The shape that is about to be deleted. */
    shape: TLShape;
}

/**
 * Options passed to {@link BindingUtil.onBeforeIsolateFromShape} and
 * {@link BindingUtil.onBeforeIsolateToShape}, describing a shape that is about to be isolated from
 * the one that it's bound to.
 *
 * Isolation happens whenever two bound shapes are separated. For example
 * 1. One is deleted, but the other is not.
 * 1. One is copied, but the other is not.
 * 1. One is duplicated, but the other is not.
 *
 * In each of these cases, if the remaining shape depends on the binding for its rendering, it may
 * now be in an inconsistent state. For example, tldraw's arrow shape depends on the binding to know
 * where the end of the arrow is. If we removed the binding without doing anything else, the arrow
 * would suddenly be pointing to the wrong location. Instead, when the shape the arrow is pointing
 * to is deleted, or the arrow is copied/duplicated, we use an isolation callback. The callback
 * updates the arrow based on the binding that's about to be removed, so it doesn't end up pointing
 * to the wrong place.
 *
 * For this style of consistency update, use isolation callbacks. For actions specific to deletion
 * (like deleting a sticker when the shape it's bound to is removed), use the delete callbacks
 * ({@link BindingUtil.onBeforeDeleteFromShape} and {@link BindingUtil.onBeforeDeleteToShape})
 * instead.
 *
 * @public
 */
export declare interface BindingOnShapeIsolateOptions<Binding extends TLUnknownBinding> {
    /** The binding record that refers to the shape in question. */
    binding: Binding;
    /**
     * The shape being removed. For deletion, this is the deleted shape. For copy/duplicate, this is
     * the shape that _isn't_ being copied/duplicated and is getting left behind.
     */
    removedShape: TLShape;
}

/** @public */
export declare abstract class BindingUtil<Binding extends TLUnknownBinding = TLUnknownBinding> {
    editor: Editor;
    constructor(editor: Editor);
    static props?: RecordProps<TLUnknownBinding>;
    static migrations?: TLPropsMigrations;
    /**
     * The type of the binding util, which should match the binding's type.
     *
     * @public
     */
    static type: string;
    /**
     * Get the default props for a binding.
     *
     * @public
     */
    abstract getDefaultProps(): Partial<Binding['props']>;
    /**
     * Called whenever a store operation involving this binding type has completed. This is useful
     * for working with networks of related bindings that may need to update together.
     *
     * @example
     * ```ts
     * class MyBindingUtil extends BindingUtil<MyBinding> {
     *   changedBindingIds = new Set<TLBindingId>()
     *
     *   onOperationComplete() {
     *     doSomethingWithChangedBindings(this.changedBindingIds)
     *     this.changedBindingIds.clear()
     *   }
     *
     *   onAfterChange({ bindingAfter }: BindingOnChangeOptions<MyBinding>) {
     *     this.changedBindingIds.add(bindingAfter.id)
     *   }
     * }
     * ```
     *
     * @public
     */
    onOperationComplete?(): void;
    /**
     * Called when a binding is about to be created. See {@link BindingOnCreateOptions} for details.
     *
     * You can optionally return a new binding to replace the one being created - for example, to
     * set different initial props.
     *
     * @public
     */
    onBeforeCreate?(options: BindingOnCreateOptions<Binding>): Binding | void;
    /**
     * Called after a binding has been created. See {@link BindingOnCreateOptions} for details.
     *
     * @public
     */
    onAfterCreate?(options: BindingOnCreateOptions<Binding>): void;
    /**
     * Called when a binding is about to be changed. See {@link BindingOnChangeOptions} for details.
     *
     * Note that this only fires when the binding record is changing, not when the shapes
     * associated change. Use {@link BindingUtil.onAfterChangeFromShape} and
     * {@link BindingUtil.onAfterChangeToShape} for that.
     *
     * You can optionally return a new binding to replace the one being changed - for example, to
     * enforce constraints on the binding's props.
     *
     * @public
     */
    onBeforeChange?(options: BindingOnChangeOptions<Binding>): Binding | void;
    /**
     * Called after a binding has been changed. See {@link BindingOnChangeOptions} for details.
     *
     * Note that this only fires when the binding record is changing, not when the shapes
     * associated change. Use {@link BindingUtil.onAfterChangeFromShape} and
     * {@link BindingUtil.onAfterChangeToShape} for that.
     *
     * @public
     */
    onAfterChange?(options: BindingOnChangeOptions<Binding>): void;
    /**
     * Called when a binding is about to be deleted. See {@link BindingOnDeleteOptions} for details.
     *
     * @public
     */
    onBeforeDelete?(options: BindingOnDeleteOptions<Binding>): void;
    /**
     * Called after a binding has been deleted. See {@link BindingOnDeleteOptions} for details.
     *
     * @public
     */
    onAfterDelete?(options: BindingOnDeleteOptions<Binding>): void;
    /**
     * Called after the shape referenced in a binding's `fromId` is changed. Use this to propagate
     * any changes to the binding itself or the other shape as needed. See
     * {@link BindingOnShapeChangeOptions} for details.
     *
     * @public
     */
    onAfterChangeFromShape?(options: BindingOnShapeChangeOptions<Binding>): void;
    /**
     * Called after the shape referenced in a binding's `toId` is changed. Use this to propagate any
     * changes to the binding itself or the other shape as needed. See
     * {@link BindingOnShapeChangeOptions} for details.
     *
     * @public
     */
    onAfterChangeToShape?(options: BindingOnShapeChangeOptions<Binding>): void;
    /**
     * Called before the shape referenced in a binding's `fromId` is about to be deleted. Use this
     * with care - you may want to use {@link BindingUtil.onBeforeIsolateToShape} instead. See
     * {@link BindingOnShapeDeleteOptions} for details.
     *
     * @public
     */
    onBeforeDeleteFromShape?(options: BindingOnShapeDeleteOptions<Binding>): void;
    /**
     * Called before the shape referenced in a binding's `toId` is about to be deleted. Use this
     * with care - you may want to use {@link BindingUtil.onBeforeIsolateFromShape} instead. See
     * {@link BindingOnShapeDeleteOptions} for details.
     *
     * @public
     */
    onBeforeDeleteToShape?(options: BindingOnShapeDeleteOptions<Binding>): void;
    /**
     * Called before the shape referenced in a binding's `fromId` is about to be isolated from the
     * shape referenced in `toId`. See {@link BindingOnShapeIsolateOptions} for discussion on what
     * isolation means, and when/how to use this callback.
     */
    onBeforeIsolateFromShape?(options: BindingOnShapeIsolateOptions<Binding>): void;
    /**
     * Called before the shape referenced in a binding's `toId` is about to be isolated from the
     * shape referenced in `fromId`. See {@link BindingOnShapeIsolateOptions} for discussion on what
     * isolation means, and when/how to use this callback.
     */
    onBeforeIsolateToShape?(options: BindingOnShapeIsolateOptions<Binding>): void;
}

/**
 * When moving or resizing shapes, the bounds of the shape can snap to key geometry on other nearby
 * shapes. Customize how a shape snaps to others with {@link ShapeUtil.getBoundsSnapGeometry}.
 *
 * @public
 */
export declare interface BoundsSnapGeometry {
    /**
     * Points that this shape will snap to. By default, this will be the corners and center of the
     * shapes bounding box. To disable snapping to a specific point, use an empty array.
     */
    points?: VecModel[];
}

/** @public */
export declare interface BoundsSnapPoint {
    id: string;
    x: number;
    y: number;
    handle?: SelectionCorner;
}

/** @public */
export declare class BoundsSnaps {
    readonly manager: SnapManager;
    readonly editor: Editor;
    constructor(manager: SnapManager);
    private getSnapPointsCache;
    getSnapPoints(shapeId: TLShapeId): BoundsSnapPoint[];
    private getSnappablePoints;
    private getSnappableGapNodes;
    private getVisibleGaps;
    snapTranslateShapes({ lockedAxis, initialSelectionPageBounds, initialSelectionSnapPoints, dragDelta, }: {
        dragDelta: Vec;
        initialSelectionPageBounds: Box;
        initialSelectionSnapPoints: BoundsSnapPoint[];
        lockedAxis: 'x' | 'y' | null;
    }): SnapData;
    snapResizeShapes({ initialSelectionPageBounds, dragDelta, handle: originalHandle, isAspectRatioLocked, isResizingFromCenter, }: {
        dragDelta: Vec;
        handle: SelectionCorner | SelectionEdge;
        initialSelectionPageBounds: Box;
        isAspectRatioLocked: boolean;
        isResizingFromCenter: boolean;
    }): SnapData;
    private collectPointSnaps;
    private collectGapSnaps;
    private getPointSnapLines;
    private getGapSnapLines;
}

/** @public */
export declare class Box {
    constructor(x?: number, y?: number, w?: number, h?: number);
    x: number;
    y: number;
    w: number;
    h: number;
    get point(): Vec;
    set point(val: Vec);
    get minX(): number;
    set minX(n: number);
    get midX(): number;
    get maxX(): number;
    get minY(): number;
    set minY(n: number);
    get midY(): number;
    get maxY(): number;
    get width(): number;
    set width(n: number);
    get height(): number;
    set height(n: number);
    get aspectRatio(): number;
    get center(): Vec;
    set center(v: Vec);
    get corners(): Vec[];
    get cornersAndCenter(): Vec[];
    get sides(): Array<[Vec, Vec]>;
    get size(): Vec;
    toFixed(): this;
    setTo(B: Box): this;
    set(x?: number, y?: number, w?: number, h?: number): this;
    expand(A: Box): this;
    expandBy(n: number): this;
    scale(n: number): this;
    clone(): Box;
    translate(delta: VecLike): this;
    snapToGrid(size: number): void;
    collides(B: Box): boolean;
    contains(B: Box): boolean;
    includes(B: Box): boolean;
    containsPoint(V: VecLike, margin?: number): boolean;
    getHandlePoint(handle: SelectionCorner | SelectionEdge): Vec;
    toJson(): BoxModel;
    resize(handle: SelectionCorner | SelectionEdge | string, dx: number, dy: number): void;
    union(box: BoxModel): this;
    static From(box: BoxModel): Box;
    static FromCenter(center: VecLike, size: VecLike): Box;
    static FromPoints(points: VecLike[]): Box;
    static Expand(A: Box, B: Box): Box;
    static ExpandBy(A: Box, n: number): Box;
    static Collides: (A: Box, B: Box) => boolean;
    static Contains: (A: Box, B: Box) => boolean;
    static Includes: (A: Box, B: Box) => boolean;
    static ContainsPoint: (A: Box, B: VecLike, margin?: number) => boolean;
    static Common: (boxes: Box[]) => Box;
    static Sides: (A: Box, inset?: number) => Vec[][];
    static Resize(box: Box, handle: SelectionCorner | SelectionEdge | string, dx: number, dy: number, isAspectRatioLocked?: boolean): {
        box: Box;
        scaleX: number;
        scaleY: number;
    };
    equals(other: Box | BoxModel): boolean;
    static Equals(a: Box | BoxModel, b: Box | BoxModel): boolean;
    zeroFix(): this;
    static ZeroFix(other: Box | BoxModel): Box;
}

/** @public */
export declare type BoxLike = Box | BoxModel;

/**
 * @param a - Any angle in radians
 * @returns A number between 0 and 2 * PI
 * @public
 */
export declare function canonicalizeRotation(a: number): number;

/**
 * Get the center of a circle from three points.
 *
 * @param a - The first point
 * @param b - The second point
 * @param c - The third point
 *
 * @returns The center of the circle
 *
 * @public
 */
export declare function centerOfCircleFromThreePoints(a: VecLike, b: VecLike, c: VecLike): Vec;

/** @public */
export declare class Circle2d extends Geometry2d {
    config: Omit<Geometry2dOptions, 'isClosed'> & {
        isFilled: boolean;
        radius: number;
        x?: number;
        y?: number;
    };
    _center: Vec;
    radius: number;
    x: number;
    y: number;
    constructor(config: Omit<Geometry2dOptions, 'isClosed'> & {
        isFilled: boolean;
        radius: number;
        x?: number;
        y?: number;
    });
    getBounds(): Box;
    getVertices(): Vec[];
    nearestPoint(point: Vec): Vec;
    hitTestLineSegment(A: Vec, B: Vec, distance?: number): boolean;
    getSvgPathData(): string;
}

/**
 * Clamp a value into a range.
 *
 * @example
 *
 * ```ts
 * const A = clamp(0, 1) // 1
 * ```
 *
 * @param n - The number to clamp.
 * @param min - The minimum value.
 * @public
 */
export declare function clamp(n: number, min: number): number;

/**
 * Clamp a value into a range.
 *
 * @example
 *
 * ```ts
 * const A = clamp(0, 1, 10) // 1
 * const B = clamp(11, 1, 10) // 10
 * const C = clamp(5, 1, 10) // 5
 * ```
 *
 * @param n - The number to clamp.
 * @param min - The minimum value.
 * @param max - The maximum value.
 * @public
 */
export declare function clamp(n: number, min: number, max: number): number;

/**
 * Clamp radians within 0 and 2PI
 *
 * @param r - The radian value.
 * @public
 */
export declare function clampRadians(r: number): number;

/** @public */
export declare class ClickManager {
    editor: Editor;
    constructor(editor: Editor);
    private _clickId;
    private _clickTimeout?;
    private _clickScreenPoint?;
    private _previousScreenPoint?;
    private _getClickTimeout;
    /* Excluded from this release type: _clickState */
    /**
     * The current click state.
     *
     * @public
     */
    get clickState(): TLClickState | undefined;
    lastPointerInfo: TLPointerEventInfo;
    handlePointerEvent: (info: TLPointerEventInfo) => TLClickEventInfo | TLPointerEventInfo;
    /* Excluded from this release type: cancelDoubleClickTimeout */
}

/**
 * Get the clockwise angle distance between two angles.
 *
 * @param a0 - The first angle.
 * @param a1 - The second angle.
 * @public
 */
export declare function clockwiseAngleDist(a0: number, a1: number): number;

export { computed }

/* Excluded from this release type: ContainerProvider */

/** @public */
export declare const coreShapes: readonly [typeof GroupShapeUtil];

/**
 * Get the counter-clockwise angle distance between two angles.
 *
 * @param a0 - The first angle.
 * @param a1 - The second angle.
 * @public
 */
export declare function counterClockwiseAngleDist(a0: number, a1: number): number;

/**
 * Creates a signal of the instance state for a given store.
 * @public
 * @param store - The store to create the instance state snapshot signal for
 * @returns
 */
export declare function createSessionStateSnapshotSignal(store: TLStore): Signal<null | TLSessionStateSnapshot>;

/**
 * A helper for creating a TLStore schema from either an object with shapeUtils, bindingUtils, and
 * migrations, or a schema.
 *
 * @param opts - Options for creating the schema.
 *
 * @public
 */
export declare function createTLSchemaFromUtils(opts: TLStoreSchemaOptions): StoreSchema<TLRecord, TLStoreProps>;

/**
 * A helper for creating a TLStore.
 *
 * @param opts - Options for creating the store.
 *
 * @public
 */
export declare function createTLStore({ initialData, defaultName, id, assets, onMount, collaboration, ...rest }?: TLStoreOptions): TLStore;

/** @public */
export declare function createTLUser(opts?: {
    setUserPreferences?: ((userPreferences: TLUserPreferences) => void) | undefined;
    userPreferences?: Signal<TLUserPreferences, unknown> | undefined;
}): TLUser;

/** @public */
export declare class CubicBezier2d extends Polyline2d {
    a: Vec;
    b: Vec;
    c: Vec;
    d: Vec;
    constructor(config: Omit<Geometry2dOptions, 'isClosed' | 'isFilled'> & {
        cp1: Vec;
        cp2: Vec;
        end: Vec;
        start: Vec;
    });
    getVertices(): Vec[];
    midPoint(): Vec;
    nearestPoint(A: Vec): Vec;
    getSvgPathData(first?: boolean): string;
    static GetAtT(segment: CubicBezier2d, t: number): Vec;
    getLength(precision?: number): number;
}

/** @public */
export declare class CubicSpline2d extends Geometry2d {
    points: Vec[];
    constructor(config: Omit<Geometry2dOptions, 'isClosed' | 'isFilled'> & {
        points: Vec[];
    });
    _segments?: CubicBezier2d[];
    get segments(): CubicBezier2d[];
    getLength(): number;
    getVertices(): Vec[];
    nearestPoint(A: Vec): Vec;
    hitTestLineSegment(A: Vec, B: Vec): boolean;
    getSvgPathData(): string;
}

/** @public */
export declare function dataUrlToFile(url: string, filename: string, mimeType: string): Promise<File>;

/** @public */
export declare function debugEnableLicensing(): void;

/* Excluded from this release type: DebugFlag */

/* Excluded from this release type: DebugFlagDef */

/* Excluded from this release type: DebugFlagDefaults */

/* Excluded from this release type: debugFlags */

/* Excluded from this release type: DEFAULT_ANIMATION_OPTIONS */

/* Excluded from this release type: DEFAULT_CAMERA_OPTIONS */

/** @public @react */
export declare function DefaultBackground(): JSX_2.Element;

/** @public @react */
export declare const DefaultBrush: ({ brush, color, opacity, className }: TLBrushProps) => JSX_2.Element;

/** @public @react */
export declare function DefaultCanvas({ className }: TLCanvasComponentProps): JSX_2.Element;

/** @public @react */
export declare function DefaultCollaboratorHint({ className, zoom, point, color, viewport, opacity, }: TLCollaboratorHintProps): JSX_2.Element;

/** @public @react */
export declare const DefaultCursor: NamedExoticComponent<TLCursorProps>;

/** @public @react */
export declare const DefaultErrorFallback: TLErrorFallbackComponent;

/** @public @react */
export declare function DefaultGrid({ x, y, z, size }: TLGridProps): JSX_2.Element;

/** @public @react */
export declare function DefaultHandle({ handle, isCoarse, className, zoom }: TLHandleProps): JSX_2.Element;

/** @public @react */
export declare const DefaultHandles: ({ children }: TLHandlesProps) => JSX_2.Element;

/** @public @react */
export declare function DefaultScribble({ scribble, zoom, color, opacity, className }: TLScribbleProps): JSX_2.Element | null;

/** @public @react */
export declare function DefaultSelectionBackground({ bounds, rotation }: TLSelectionBackgroundProps): JSX_2.Element;

/** @public @react */
export declare function DefaultSelectionForeground({ bounds, rotation }: TLSelectionForegroundProps): JSX_2.Element;

/** @public @react */
export declare const DefaultShapeIndicator: NamedExoticComponent<TLShapeIndicatorProps>;

/** @public @react */
export declare const DefaultShapeIndicators: NamedExoticComponent<object>;

/** @public @react */
export declare function DefaultSnapIndicator({ className, line, zoom }: TLSnapIndicatorProps): JSX_2.Element;

/** @public @react */
export declare function DefaultSpinner(): JSX_2.Element;

/** @public @react */
export declare const DefaultSvgDefs: () => null;

/** @public */
export declare const defaultTldrawOptions: {
    readonly adjacentShapeMargin: 10;
    readonly animationMediumMs: 320;
    readonly cameraMovingTimeoutMs: 64;
    readonly cameraSlideFriction: 0.09;
    readonly coarseDragDistanceSquared: 36;
    readonly coarseHandleRadius: 20;
    readonly coarsePointerWidth: 12;
    readonly collaboratorCheckIntervalMs: 1200;
    readonly collaboratorIdleTimeoutMs: 3000;
    readonly collaboratorInactiveTimeoutMs: 60000;
    readonly defaultSvgPadding: 32;
    readonly doubleClickDurationMs: 450;
    readonly dragDistanceSquared: 16;
    readonly edgeScrollDelay: 200;
    readonly edgeScrollDistance: 8;
    readonly edgeScrollEaseDuration: 200;
    readonly edgeScrollSpeed: 25;
    readonly flattenImageBoundsExpand: 64;
    readonly flattenImageBoundsPadding: 16;
    readonly followChaseViewportSnap: 2;
    readonly gridSteps: readonly [{
        readonly mid: 0.15;
        readonly min: -1;
        readonly step: 64;
    }, {
        readonly mid: 0.375;
        readonly min: 0.05;
        readonly step: 16;
    }, {
        readonly mid: 1;
        readonly min: 0.15;
        readonly step: 4;
    }, {
        readonly mid: 2.5;
        readonly min: 0.7;
        readonly step: 1;
    }];
    readonly handleRadius: 12;
    readonly hitTestMargin: 8;
    readonly longPressDurationMs: 500;
    readonly maxPages: 40;
    readonly maxPointsPerDrawShape: 500;
    readonly maxShapesPerPage: 4000;
    readonly multiClickDurationMs: 200;
    readonly textShadowLod: 0.35;
};

/** @public */
export declare const defaultUserPreferences: Readonly<{
    animationSpeed: 0 | 1;
    color: "#02B1CC" | "#11B3A3" | "#39B178" | "#55B467" | "#7B66DC" | "#9D5BD2" | "#BD54C6" | "#E34BA9" | "#EC5E41" | "#F04F88" | "#F2555A" | "#FF802B";
    colorScheme: "system";
    edgeScrollSpeed: 1;
    isDynamicSizeMode: false;
    isPasteAtCursorMode: false;
    isSnapMode: false;
    isWrapMode: false;
    locale: "ar" | "ca" | "cs" | "da" | "de" | "en" | "es" | "fa" | "fi" | "fr" | "gl" | "he" | "hi-in" | "hr" | "hu" | "id" | "it" | "ja" | "ko-kr" | "ku" | "my" | "ne" | "no" | "pl" | "pt-br" | "pt-pt" | "ro" | "ru" | "sl" | "sv" | "te" | "th" | "tr" | "uk" | "vi" | "zh-cn" | "zh-tw";
    name: "New User";
}>;

/**
 * Convert degrees to radians.
 *
 * @param d - The degree in degrees.
 * @public
 */
export declare function degreesToRadians(d: number): number;

/** @public */
export declare const EASINGS: {
    readonly easeInCubic: (t: number) => number;
    readonly easeInExpo: (t: number) => number;
    readonly easeInOutCubic: (t: number) => number;
    readonly easeInOutExpo: (t: number) => number;
    readonly easeInOutQuad: (t: number) => number;
    readonly easeInOutQuart: (t: number) => number;
    readonly easeInOutQuint: (t: number) => number;
    readonly easeInOutSine: (t: number) => number;
    readonly easeInQuad: (t: number) => number;
    readonly easeInQuart: (t: number) => number;
    readonly easeInQuint: (t: number) => number;
    readonly easeInSine: (t: number) => number;
    readonly easeOutCubic: (t: number) => number;
    readonly easeOutExpo: (t: number) => number;
    readonly easeOutQuad: (t: number) => number;
    readonly easeOutQuart: (t: number) => number;
    readonly easeOutQuint: (t: number) => number;
    readonly easeOutSine: (t: number) => number;
    readonly linear: (t: number) => number;
};

/** @public */
export declare class Edge2d extends Geometry2d {
    start: Vec;
    end: Vec;
    d: Vec;
    u: Vec;
    ul: number;
    constructor(config: {
        end: Vec;
        start: Vec;
    });
    getLength(): number;
    midPoint(): Vec;
    getVertices(): Vec[];
    nearestPoint(point: Vec): Vec;
    hitTestLineSegment(A: Vec, B: Vec, distance?: number): boolean;
    getSvgPathData(first?: boolean): string;
}

/** @public */
export declare class EdgeScrollManager {
    editor: Editor;
    constructor(editor: Editor);
    private _isEdgeScrolling;
    private _edgeScrollDuration;
    /**
     * Update the camera position when the mouse is close to the edge of the screen.
     * Run this on every tick when in a state where edge scrolling is enabled.
     *
     * @public
     */
    updateEdgeScrolling(elapsed: number): void;
    /* Excluded from this release type: getEdgeProximityFactors */
    private getEdgeScroll;
    /**
     * Moves the camera when the mouse is close to the edge of the screen.
     * @public
     */
    private moveCameraWhenCloseToEdge;
}

/** @public */
export declare class Editor extends EventEmitter<TLEventMap> {
    constructor({ store, user, shapeUtils, bindingUtils, tools, getContainer, cameraOptions, initialState, autoFocus, inferDarkMode, options, }: TLEditorOptions);
    readonly options: TldrawOptions;
    /**
     * The editor's store
     *
     * @public
     */
    readonly store: TLStore;
    /**
     * The root state of the statechart.
     *
     * @public
     */
    readonly root: StateNode;
    /**
     * A set of functions to call when the app is disposed.
     *
     * @public
     */
    readonly disposables: Set<() => void>;
    /**
     * Whether the editor is disposed.
     *
     * @public
     */
    isDisposed: boolean;
    /* Excluded from this release type: _tickManager */
    /**
     * A manager for the app's snapping feature.
     *
     * @public
     */
    readonly snaps: SnapManager;
    /**
     * A manager for the any asynchronous events and making sure they're
     * cleaned up upon disposal.
     *
     * @public
     */
    readonly timers: Timers;
    /**
     * A manager for the user and their preferences.
     *
     * @public
     */
    readonly user: UserPreferencesManager;
    /**
     * A helper for measuring text.
     *
     * @public
     */
    readonly textMeasure: TextManager;
    /**
     * A manager for the editor's environment.
     *
     * @public
     */
    readonly environment: EnvironmentManager;
    /**
     * A manager for the editor's scribbles.
     *
     * @public
     */
    readonly scribbles: ScribbleManager;
    /**
     * A manager for side effects and correct state enforcement. See {@link @tldraw/store#StoreSideEffects} for details.
     *
     * @public
     */
    readonly sideEffects: StoreSideEffects<TLRecord>;
    /**
     * A manager for moving the camera when the mouse is at the edge of the screen.
     *
     * @public
     */
    edgeScrollManager: EdgeScrollManager;
    /* Excluded from this release type: focusManager */
    /**
     * The current HTML element containing the editor.
     *
     * @example
     * ```ts
     * const container = editor.getContainer()
     * ```
     *
     * @public
     */
    getContainer: () => HTMLElement;
    /**
     * Dispose the editor.
     *
     * @public
     */
    dispose(): void;
    /**
     * A map of shape utility classes (TLShapeUtils) by shape type.
     *
     * @public
     */
    shapeUtils: {
        readonly [K in string]?: ShapeUtil<TLUnknownShape>;
    };
    styleProps: {
        [key: string]: Map<StyleProp<any>, string>;
    };
    /**
     * Get a shape util from a shape itself.
     *
     * @example
     * ```ts
     * const util = editor.getShapeUtil(myArrowShape)
     * const util = editor.getShapeUtil('arrow')
     * const util = editor.getShapeUtil<TLArrowShape>(myArrowShape)
     * const util = editor.getShapeUtil(TLArrowShape)('arrow')
     * ```
     *
     * @param shape - A shape, shape partial, or shape type.
     *
     * @public
     */
    getShapeUtil<S extends TLUnknownShape>(shape: S | TLShapePartial<S>): ShapeUtil<S>;
    getShapeUtil<S extends TLUnknownShape>(type: S['type']): ShapeUtil<S>;
    getShapeUtil<T extends ShapeUtil>(type: T extends ShapeUtil<infer R> ? R['type'] : string): T;
    /**
     * A map of shape utility classes (TLShapeUtils) by shape type.
     *
     * @public
     */
    bindingUtils: {
        readonly [K in string]?: BindingUtil<TLUnknownBinding>;
    };
    /**
     * Get a binding util from a binding itself.
     *
     * @example
     * ```ts
     * const util = editor.getBindingUtil(myArrowBinding)
     * const util = editor.getBindingUtil('arrow')
     * const util = editor.getBindingUtil<TLArrowBinding>(myArrowBinding)
     * const util = editor.getBindingUtil(TLArrowBinding)('arrow')
     * ```
     *
     * @param binding - A binding, binding partial, or binding type.
     *
     * @public
     */
    getBindingUtil<S extends TLUnknownBinding>(binding: {
        type: S['type'];
    } | S): BindingUtil<S>;
    getBindingUtil<S extends TLUnknownBinding>(type: S['type']): BindingUtil<S>;
    getBindingUtil<T extends BindingUtil>(type: T extends BindingUtil<infer R> ? R['type'] : string): T;
    /**
     * A manager for the app's history.
     *
     * @readonly
     */
    protected readonly history: HistoryManager<TLRecord>;
    /**
     * Undo to the last mark.
     *
     * @example
     * ```ts
     * editor.undo()
     * ```
     *
     * @public
     */
    undo(): this;
    /**
     * Whether the app can undo.
     *
     * @public
     */
    getCanUndo(): boolean;
    /**
     * Redo to the next mark.
     *
     * @example
     * ```ts
     * editor.redo()
     * ```
     *
     * @public
     */
    redo(): this;
    clearHistory(): this;
    /**
     * Whether the app can redo.
     *
     * @public
     */
    getCanRedo(): boolean;
    /**
     * Create a new "mark", or stopping point, in the undo redo history. Creating a mark will clear
     * any redos.
     *
     * @example
     * ```ts
     * editor.mark()
     * editor.mark('flip shapes')
     * ```
     *
     * @param markId - The mark's id, usually the reason for adding the mark.
     *
     * @public
     */
    mark(markId?: string): this;
    /**
     * Squash the history to the given mark id.
     *
     * @example
     * ```ts
     * editor.mark('bump shapes')
     * // ... some changes
     * editor.squashToMark('bump shapes')
     * ```
     *
     * @param markId - The mark id to squash to.
     */
    squashToMark(markId: string): this;
    /**
     * Clear all marks in the undo stack back to the next mark.
     *
     * @example
     * ```ts
     * editor.bail()
     * ```
     *
     * @public
     */
    bail(): this;
    /**
     * Clear all marks in the undo stack back to the mark with the provided mark id.
     *
     * @example
     * ```ts
     * editor.bailToMark('dragging')
     * ```
     *
     * @public
     */
    bailToMark(id: string): this;
    private _shouldIgnoreShapeLock;
    /**
     * Run a function in a transaction with optional options for context.
     * You can use the options to change the way that history is treated
     * or allow changes to locked shapes.
     *
     * @example
     * ```ts
     * // updating with
     * editor.run(() => {
     * 	editor.updateShape({ ...myShape, x: 100 })
     * }, { history: "ignore" })
     *
     * // forcing changes / deletions for locked shapes
     * editor.toggleLock([myShape])
     * editor.run(() => {
     * 	editor.updateShape({ ...myShape, x: 100 })
     * 	editor.deleteShape(myShape)
     * }, { ignoreShapeLock: true }, )
     * ```
     *
     * @param fn - The callback function to run.
     * @param opts - The options for the batch.
     *
     *
     * @public
     */
    run(fn: () => void, opts?: TLEditorRunOptions): this;
    /**
     * @deprecated Use `Editor.run` instead.
     */
    batch(fn: () => void, opts?: TLEditorRunOptions): this;
    /* Excluded from this release type: annotateError */
    /* Excluded from this release type: createErrorAnnotations */
    /* Excluded from this release type: _crashingError */
    /* Excluded from this release type: getCrashingError */
    /* Excluded from this release type: crash */
    /**
     * The editor's current path of active states.
     *
     * @example
     * ```ts
     * editor.getPath() // "select.idle"
     * ```
     *
     * @public
     */
    getPath(): string;
    /**
     * Get whether a certain tool (or other state node) is currently active.
     *
     * @example
     * ```ts
     * editor.isIn('select')
     * editor.isIn('select.brushing')
     * ```
     *
     * @param path - The path of active states, separated by periods.
     *
     * @public
     */
    isIn(path: string): boolean;
    /**
     * Get whether the state node is in any of the given active paths.
     *
     * @example
     * ```ts
     * state.isInAny('select', 'erase')
     * state.isInAny('select.brushing', 'erase.idle')
     * ```
     *
     * @public
     */
    isInAny(...paths: string[]): boolean;
    /**
     * Set the selected tool.
     *
     * @example
     * ```ts
     * editor.setCurrentTool('hand')
     * editor.setCurrentTool('hand', { date: Date.now() })
     * ```
     *
     * @param id - The id of the tool to select.
     * @param info - Arbitrary data to pass along into the transition.
     *
     * @public
     */
    setCurrentTool(id: string, info?: {}): this;
    /**
     * The current selected tool.
     *
     * @public
     */
    getCurrentTool(): StateNode;
    /**
     * The id of the current selected tool.
     *
     * @public
     */
    getCurrentToolId(): string;
    /**
     * Get a descendant by its path.
     *
     * @example
     * ```ts
     * state.getStateDescendant('select')
     * state.getStateDescendant('select.brushing')
     * ```
     *
     * @param path - The descendant's path of state ids, separated by periods.
     *
     * @public
     */
    getStateDescendant<T extends StateNode>(path: string): T | undefined;
    /**
     * The global document settings that apply to all users.
     *
     * @public
     **/
    getDocumentSettings(): TLDocument;
    /**
     * Update the global document settings that apply to all users.
     *
     * @public
     **/
    updateDocumentSettings(settings: Partial<TLDocument>): this;
    /**
     * The current instance's state.
     *
     * @public
     */
    getInstanceState(): TLInstance;
    /**
     * Update the instance's state.
     *
     * @param partial - A partial object to update the instance state with.
     *
     * @public
     */
    updateInstanceState(partial: Partial<Omit<TLInstance, 'currentPageId'>>, historyOptions?: TLHistoryBatchOptions): this;
    /* Excluded from this release type: _updateInstanceState */
    /* Excluded from this release type: _isChangingStyleTimeout */
    /**
     * A set of strings representing any open menus. When menus are open,
     * certain interactions will behave differently; for example, when a
     * draw tool is selected and a menu is open, a pointer-down will not
     * create a dot (because the user is probably trying to close the menu)
     * however a pointer-down event followed by a drag will begin drawing
     * a line (because the user is BOTH trying to close the menu AND start
     * drawing a line).
     *
     * @public
     */
    getOpenMenus(): string[];
    /**
     * Add an open menu.
     *
     * @example
     * ```ts
     * editor.addOpenMenu('menu-id')
     * ```
     *
     * @public
     */
    addOpenMenu(id: string): this;
    /**
     * Delete an open menu.
     *
     * @example
     * ```ts
     * editor.deleteOpenMenu('menu-id')
     * ```
     *
     * @public
     */
    deleteOpenMenu(id: string): this;
    /**
     * Clear all open menus.
     *
     * @example
     * ```ts
     * editor.clearOpenMenus()
     * ```
     *
     * @public
     */
    clearOpenMenus(): this;
    /**
     * Get whether any menus are open.
     *
     * @example
     * ```ts
     * editor.getIsMenuOpen()
     * ```
     *
     * @public
     */
    getIsMenuOpen(): boolean;
    /**
     * Set the cursor.
     *
     * @param type - The cursor type.
     * @param rotation - The cursor rotation.
     *
     * @public
     */
    setCursor: (cursor: Partial<TLCursor>) => this;
    /**
     * Page states.
     *
     * @public
     */
    getPageStates(): TLInstancePageState[];
    /* Excluded from this release type: _getPageStatesQuery */
    /**
     * The current page state.
     *
     * @public
     */
    getCurrentPageState(): TLInstancePageState;
    /* Excluded from this release type: _getCurrentPageStateId */
    /**
     * Update this instance's page state.
     *
     * @example
     * ```ts
     * editor.updateCurrentPageState({ id: 'page1', editingShapeId: 'shape:123' })
     * ```
     *
     * @param partial - The partial of the page state object containing the changes.
     *
     * @public
     */
    updateCurrentPageState(partial: Partial<Omit<TLInstancePageState, 'editingShapeId' | 'focusedGroupId' | 'pageId' | 'selectedShapeIds'>>): this;
    private _updateCurrentPageState;
    /**
     * The current selected ids.
     *
     * @public
     */
    getSelectedShapeIds(): TLShapeId[];
    /**
     * An array containing all of the currently selected shapes.
     *
     * @public
     * @readonly
     */
    getSelectedShapes(): TLShape[];
    /**
     * Select one or more shapes.
     *
     * @example
     * ```ts
     * editor.setSelectedShapes(['id1'])
     * editor.setSelectedShapes(['id1', 'id2'])
     * ```
     *
     * @param ids - The ids to select.
     *
     * @public
     */
    setSelectedShapes(shapes: TLShape[] | TLShapeId[]): this;
    /**
     * Determine whether or not any of a shape's ancestors are selected.
     *
     * @param id - The id of the shape to check.
     *
     * @public
     */
    isAncestorSelected(shape: TLShape | TLShapeId): boolean;
    /**
     * Select one or more shapes.
     *
     * @example
     * ```ts
     * editor.select('id1')
     * editor.select('id1', 'id2')
     * ```
     *
     * @param ids - The ids to select.
     *
     * @public
     */
    select(...shapes: TLShape[] | TLShapeId[]): this;
    /**
     * Remove a shape from the existing set of selected shapes.
     *
     * @example
     * ```ts
     * editor.deselect(shape.id)
     * ```
     *
     * @public
     */
    deselect(...shapes: TLShape[] | TLShapeId[]): this;
    /**
     * Select all direct children of the current page.
     *
     * @example
     * ```ts
     * editor.selectAll()
     * ```
     *
     * @public
     */
    selectAll(): this;
    /**
     * Clear the selection.
     *
     * @example
     * ```ts
     * editor.selectNone()
     * ```
     *
     * @public
     */
    selectNone(): this;
    /**
     * The id of the app's only selected shape.
     *
     * @returns Null if there is no shape or more than one selected shape, otherwise the selected shape's id.
     *
     * @public
     * @readonly
     */
    getOnlySelectedShapeId(): null | TLShapeId;
    /**
     * The app's only selected shape.
     *
     * @returns Null if there is no shape or more than one selected shape, otherwise the selected shape.
     *
     * @public
     * @readonly
     */
    getOnlySelectedShape(): null | TLShape;
    /**
     * The current page bounds of all the selected shapes. If the
     * selection is rotated, then these bounds are the axis-aligned
     * box that the rotated bounds would fit inside of.
     *
     * @readonly
     *
     * @public
     */
    getSelectionPageBounds(): Box | null;
    /**
     * The rotation of the selection bounding box in the current page space.
     *
     * @readonly
     * @public
     */
    getSelectionRotation(): number;
    /**
     * The bounds of the selection bounding box in the current page space.
     *
     * @readonly
     * @public
     */
    getSelectionRotatedPageBounds(): Box | undefined;
    /**
     * The bounds of the selection bounding box in the current page space.
     *
     * @readonly
     * @public
     */
    getSelectionRotatedScreenBounds(): Box | undefined;
    /**
     * The current focused group id.
     *
     * @public
     */
    getFocusedGroupId(): TLPageId | TLShapeId;
    /**
     * The current focused group.
     *
     * @public
     */
    getFocusedGroup(): TLShape | undefined;
    /**
     * Set the current focused group shape.
     *
     * @param shape - The group shape id (or group shape's id) to set as the focused group shape.
     *
     * @public
     */
    setFocusedGroup(shape: null | TLGroupShape | TLShapeId): this;
    /**
     * Exit the current focused group, moving up to the next parent group if there is one.
     *
     * @public
     */
    popFocusedGroupId(): this;
    /**
     * The current editing shape's id.
     *
     * @public
     */
    getEditingShapeId(): null | TLShapeId;
    /**
     * The current editing shape.
     *
     * @public
     */
    getEditingShape(): TLShape | undefined;
    /**
     * Set the current editing shape.
     *
     * @example
     * ```ts
     * editor.setEditingShape(myShape)
     * editor.setEditingShape(myShape.id)
     * ```
     *
     * @param shape - The shape (or shape id) to set as editing.
     *
     * @public
     */
    setEditingShape(shape: null | TLShape | TLShapeId): this;
    /**
     * The current hovered shape id.
     *
     * @readonly
     * @public
     */
    getHoveredShapeId(): null | TLShapeId;
    /**
     * The current hovered shape.
     *
     * @public
     */
    getHoveredShape(): TLShape | undefined;
    /**
     * Set the editor's current hovered shape.
     *
     * @example
     * ```ts
     * editor.setHoveredShape(myShape)
     * editor.setHoveredShape(myShape.id)
     * ```
     *
     * @param shapes - The shape (or shape id) to set as hovered.
     *
     * @public
     */
    setHoveredShape(shape: null | TLShape | TLShapeId): this;
    /**
     * The editor's current hinting shape ids.
     *
     * @public
     */
    getHintingShapeIds(): TLShapeId[];
    /**
     * The editor's current hinting shapes.
     *
     * @public
     */
    getHintingShape(): NonNullable<TLShape | undefined>[];
    /**
     * Set the editor's current hinting shapes.
     *
     * @example
     * ```ts
     * editor.setHintingShapes([myShape])
     * editor.setHintingShapes([myShape.id])
     * ```
     *
     * @param shapes - The shapes (or shape ids) to set as hinting.
     *
     * @public
     */
    setHintingShapes(shapes: TLShape[] | TLShapeId[]): this;
    /**
     * The editor's current erasing ids.
     *
     * @public
     */
    getErasingShapeIds(): TLShapeId[];
    /**
     * The editor's current erasing shapes.
     *
     * @public
     */
    getErasingShapes(): NonNullable<TLShape | undefined>[];
    /**
     * Set the editor's current erasing shapes.
     *
     * @example
     * ```ts
     * editor.setErasingShapes([myShape])
     * editor.setErasingShapes([myShape.id])
     * ```
     *
     * @param shapes - The shapes (or shape ids) to set as hinting.
     *
     * @public
     */
    setErasingShapes(shapes: TLShape[] | TLShapeId[]): this;
    /**
     * The current cropping shape's id.
     *
     * @public
     */
    getCroppingShapeId(): null | TLShapeId;
    /**
     * Set the current cropping shape.
     *
     * @example
     * ```ts
     * editor.setCroppingShape(myShape)
     * editor.setCroppingShape(myShape.id)
     * ```
     *
     *
     * @param shape - The shape (or shape id) to set as cropping.
     *
     * @public
     */
    setCroppingShape(shape: null | TLShape | TLShapeId): this;
    /* Excluded from this release type: _unsafe_getCameraId */
    /**
     * The current camera.
     *
     * @public
     */
    getCamera(): TLCamera;
    private getViewportPageBoundsForFollowing;
    private getCameraForFollowing;
    /**
     * The current camera zoom level.
     *
     * @public
     */
    getZoomLevel(): number;
    /**
     * Get the camera's initial or reset zoom level.
     *
     * @example
     * ```ts
     * editor.getInitialZoom()
     * ```
     *
     * @public */
    getInitialZoom(): number;
    /**
     * Get the camera's base level for calculating actual zoom levels based on the zoom steps.
     *
     * @example
     * ```ts
     * editor.getBaseZoom()
     * ```
     *
     * @public */
    getBaseZoom(): number;
    private _cameraOptions;
    /**
     * Get the current camera options.
     *
     * @example
     * ```ts
     * editor.getCameraOptions()
     * ```
     *
     *  @public */
    getCameraOptions(): TLCameraOptions;
    /**
     * Set the camera options. Changing the options won't immediately change the camera itself, so you may want to call `setCamera` after changing the options.
     *
     * @example
     * ```ts
     * editor.setCameraOptions(myCameraOptions)
     * editor.setCamera(editor.getCamera())
     * ```
     *
     * @param options - The camera options to set.
     *
     * @public */
    setCameraOptions(options: Partial<TLCameraOptions>): this;
    /* Excluded from this release type: getConstrainedCamera */
    /* Excluded from this release type: _setCamera */
    /**
     * Set the current camera.
     *
     * @example
     * ```ts
     * editor.setCamera({ x: 0, y: 0})
     * editor.setCamera({ x: 0, y: 0, z: 1.5})
     * editor.setCamera({ x: 0, y: 0, z: 1.5}, { animation: { duration: 1000, easing: (t) => t * t } })
     * ```
     *
     * @param point - The new camera position.
     * @param opts - The camera move options.
     *
     * @public
     */
    setCamera(point: VecLike, opts?: TLCameraMoveOptions): this;
    /**
     * Center the camera on a point (in the current page space).
     *
     * @example
     * ```ts
     * editor.centerOnPoint({ x: 100, y: 100 })
     * editor.centerOnPoint({ x: 100, y: 100 }, { animation: { duration: 200 } })
     * ```
     *
     * @param point - The point in the current page space to center on.
     * @param animation - The camera move options.
     *
     * @public
     */
    centerOnPoint(point: VecLike, opts?: TLCameraMoveOptions): this;
    /**
     * Zoom the camera to fit the current page's content in the viewport.
     *
     * @example
     * ```ts
     * editor.zoomToFit()
     * editor.zoomToFit({ animation: { duration: 200 } })
     * ```
     *
     * @param opts - The camera move options.
     *
     * @public
     */
    zoomToFit(opts?: TLCameraMoveOptions): this;
    /**
     * Set the zoom back to 100%.
     *
     * @example
     * ```ts
     * editor.resetZoom()
     * editor.resetZoom(editor.getViewportScreenCenter(), { animation: { duration: 200 } })
     * editor.resetZoom(editor.getViewportScreenCenter(), { animation: { duration: 200 } })
     * ```
     *
     * @param point - The screen point to zoom out on. Defaults to the viewport screen center.
     * @param opts - The camera move options.
     *
     * @public
     */
    resetZoom(point?: Vec, opts?: TLCameraMoveOptions): this;
    /**
     * Zoom the camera in.
     *
     * @example
     * ```ts
     * editor.zoomIn()
     * editor.zoomIn(editor.getViewportScreenCenter(), { animation: { duration: 200 } })
     * editor.zoomIn(editor.inputs.currentScreenPoint, { animation: { duration: 200 } })
     * ```
     *
     * @param point - The screen point to zoom in on. Defaults to the screen center
     * @param opts - The camera move options.
     *
     * @public
     */
    zoomIn(point?: Vec, opts?: TLCameraMoveOptions): this;
    /**
     * Zoom the camera out.
     *
     * @example
     * ```ts
     * editor.zoomOut()
     * editor.zoomOut(editor.getViewportScreenCenter(), { animation: { duration: 120 } })
     * editor.zoomOut(editor.inputs.currentScreenPoint, { animation: { duration: 120 } })
     * ```
     *
     * @param point - The point to zoom out on. Defaults to the viewport screen center.
     * @param opts - The camera move options.
     *
     * @public
     */
    zoomOut(point?: Vec, opts?: TLCameraMoveOptions): this;
    /**
     * Zoom the camera to fit the current selection in the viewport.
     *
     * @example
     * ```ts
     * editor.zoomToSelection()
     * editor.zoomToSelection({ animation: { duration: 200 } })
     * ```
     *
     * @param animation - The camera move options.
     *
     * @public
     */
    zoomToSelection(opts?: TLCameraMoveOptions): this;
    /**
     * Zoom the camera to fit a bounding box (in the current page space).
     *
     * @example
     * ```ts
     * editor.zoomToBounds(myBounds)
     * editor.zoomToBounds(myBounds, { animation: { duration: 200 } })
     * editor.zoomToBounds(myBounds, { animation: { duration: 200 }, inset: 0, targetZoom: 1 })
     * ```
     *
     * @param bounds - The bounding box.
     * @param opts - The camera move options, target zoom, or custom inset amount.
     *
     * @public
     */
    zoomToBounds(bounds: BoxLike, opts?: {
        inset?: number;
        targetZoom?: number;
    } & TLCameraMoveOptions): this;
    /**
     * Stop the current camera animation, if any.
     *
     * @example
     * ```ts
     * editor.stopCameraAnimation()
     * ```
     *
     * @public
     */
    stopCameraAnimation(): this;
    /* Excluded from this release type: _viewportAnimation */
    /* Excluded from this release type: _animateViewport */
    /* Excluded from this release type: _animateToViewport */
    /**
     * Slide the camera in a certain direction.
     *
     * @example
     * ```ts
     * editor.slideCamera({ speed: 1, direction: { x: 1, y: 0 }, friction: 0.1 })
     * ```
     *
     * @param opts - Options for the slide
     * @public
     */
    slideCamera(opts?: {
        direction: VecLike;
        force?: boolean | undefined;
        friction?: number | undefined;
        speed: number;
        speedThreshold?: number | undefined;
    }): this;
    /**
     * Animate the camera to a user's cursor position. This also briefly show the user's cursor if it's not currently visible.
     *
     * @example
     * ```ts
     * editor.zoomToUser(myUserId)
     * editor.zoomToUser(myUserId, { animation: { duration: 200 } })
     * ```
     *
     * @param userId - The id of the user to animate to.
     * @param opts - The camera move options.
     * @public
     */
    zoomToUser(userId: string, opts?: TLCameraMoveOptions): this;
    /* Excluded from this release type: _willSetInitialBounds */
    /**
     * Update the viewport. The viewport will measure the size and screen position of its container
     * element. This should be done whenever the container's position on the screen changes.
     *
     * @example
     * ```ts
     * editor.updateViewportScreenBounds(new Box(0, 0, 1280, 1024))
     * editor.updateViewportScreenBounds(new Box(0, 0, 1280, 1024), true)
     * ```
     *
     * @param center - Whether to preserve the viewport page center as the viewport changes.
     *
     * @public
     */
    updateViewportScreenBounds(screenBounds: Box, center?: boolean): this;
    /**
     * The bounds of the editor's viewport in screen space.
     *
     * @public
     */
    getViewportScreenBounds(): Box;
    /**
     * The center of the editor's viewport in screen space.
     *
     * @public
     */
    getViewportScreenCenter(): Vec;
    /**
     * The current viewport in the current page space.
     *
     * @public
     */
    getViewportPageBounds(): Box;
    /**
     * Convert a point in screen space to a point in the current page space.
     *
     * @example
     * ```ts
     * editor.screenToPage({ x: 100, y: 100 })
     * ```
     *
     * @param point - The point in screen space.
     *
     * @public
     */
    screenToPage(point: VecLike): Vec;
    /**
     * Convert a point in the current page space to a point in current screen space.
     *
     * @example
     * ```ts
     * editor.pageToScreen({ x: 100, y: 100 })
     * ```
     *
     * @param point - The point in page space.
     *
     * @public
     */
    pageToScreen(point: VecLike): Vec;
    /**
     * Convert a point in the current page space to a point in current viewport space.
     *
     * @example
     * ```ts
     * editor.pageToViewport({ x: 100, y: 100 })
     * ```
     *
     * @param point - The point in page space.
     *
     * @public
     */
    pageToViewport(point: VecLike): Vec;
    private _getCollaboratorsQuery;
    /**
     * Returns a list of presence records for all peer collaborators.
     * This will return the latest presence record for each connected user.
     *
     * @public
     */
    getCollaborators(): TLInstancePresence[];
    /**
     * Returns a list of presence records for all peer collaborators on the current page.
     * This will return the latest presence record for each connected user.
     *
     * @public
     */
    getCollaboratorsOnCurrentPage(): TLInstancePresence[];
    private _isLockedOnFollowingUser;
    /**
     * Start viewport-following a user.
     *
     * @example
     * ```ts
     * editor.startFollowingUser(myUserId)
     * ```
     *
     * @param userId - The id of the user to follow.
     * @param opts - Options for starting to follow a user.
     *
     * @public
     */
    startFollowingUser(userId: string): this;
    /**
     * Stop viewport-following a user.
     *
     * @example
     * ```ts
     * editor.stopFollowingUser()
     * ```
     * @public
     */
    stopFollowingUser(): this;
    /* Excluded from this release type: getUnorderedRenderingShapes */
    private _cameraState;
    private _cameraStateTimeoutRemaining;
    private _decayCameraStateTimeout;
    private _tickCameraState;
    /**
     * Whether the camera is moving or idle.
     *
     * @example
     * ```ts
     * editor.getCameraState()
     * ```
     *
     * @public
     */
    getCameraState(): "idle" | "moving";
    /**
     * Get the shapes that should be displayed in the current viewport.
     *
     * @example
     * ```ts
     * editor.getRenderingShapes()
     * ```
     *
     * @public
     */
    getRenderingShapes(): {
        backgroundIndex: number;
        id: TLShapeId;
        index: number;
        opacity: number;
        shape: TLShape;
        util: ShapeUtil<TLUnknownShape>;
    }[];
    private _getAllPagesQuery;
    /**
     * Info about the project's current pages.
     *
     * @example
     * ```ts
     * editor.getPages()
     * ```
     *
     * @public
     */
    getPages(): TLPage[];
    /**
     * The current page.
     *
     * @example
     * ```ts
     * editor.getCurrentPage()
     * ```
     *
     * @public
     */
    getCurrentPage(): TLPage;
    /**
     * The current page id.
     *
     * @example
     * ```ts
     * editor.getCurrentPageId()
     * ```
     *
     * @public
     */
    getCurrentPageId(): TLPageId;
    /**
     * Get a page.
     *
     * @example
     * ```ts
     * editor.getPage(myPage.id)
     * editor.getPage(myPage)
     * ```
     *
     * @param page - The page (or page id) to get.
     *
     * @public
     */
    getPage(page: TLPage | TLPageId): TLPage | undefined;
    private readonly _currentPageShapeIds;
    /**
     * An array of all of the shapes on the current page.
     *
     * @example
     * ```ts
     * editor.getCurrentPageIds()
     * ```
     *
     * @public
     */
    getCurrentPageShapeIds(): Set<TLShapeId>;
    /* Excluded from this release type: getCurrentPageShapeIdsSorted */
    /**
     * Get the ids of shapes on a page.
     *
     * @example
     * ```ts
     * const idsOnPage1 = editor.getPageShapeIds('page1')
     * const idsOnPage2 = editor.getPageShapeIds(myPage2)
     * ```
     *
     * @param page - The page (or page id) to get.
     *
     * @public
     **/
    getPageShapeIds(page: TLPage | TLPageId): Set<TLShapeId>;
    /**
     * Set the current page.
     *
     * @example
     * ```ts
     * editor.setCurrentPage('page1')
     * editor.setCurrentPage(myPage1)
     * ```
     *
     * @param page - The page (or page id) to set as the current page.
     *
     * @public
     */
    setCurrentPage(page: TLPage | TLPageId): this;
    /**
     * Update a page.
     *
     * @example
     * ```ts
     * editor.updatePage({ id: 'page2', name: 'Page 2' })
     * ```
     *
     * @param partial - The partial of the shape to update.
     *
     * @public
     */
    updatePage(partial: RequiredKeys<Partial<TLPage>, 'id'>): this;
    /**
     * Create a page.
     *
     * @example
     * ```ts
     * editor.createPage(myPage)
     * editor.createPage({ name: 'Page 2' })
     * ```
     *
     * @param page - The page (or page partial) to create.
     *
     * @public
     */
    createPage(page: Partial<TLPage>): this;
    /**
     * Delete a page.
     *
     * @example
     * ```ts
     * editor.deletePage('page1')
     * ```
     *
     * @param id - The id of the page to delete.
     *
     * @public
     */
    deletePage(page: TLPage | TLPageId): this;
    /**
     * Duplicate a page.
     *
     * @param id - The id of the page to duplicate. Defaults to the current page.
     * @param createId - The id of the new page. Defaults to a new id.
     *
     * @public
     */
    duplicatePage(page: TLPage | TLPageId, createId?: TLPageId): this;
    /**
     * Rename a page.
     *
     * @example
     * ```ts
     * editor.renamePage('page1', 'My Page')
     * ```
     *
     * @param id - The id of the page to rename.
     * @param name - The new name.
     *
     * @public
     */
    renamePage(page: TLPage | TLPageId, name: string): this;
    /* Excluded from this release type: _getAllAssetsQuery */
    /**
     * Get all assets in the editor.
     *
     * @public
     */
    getAssets(): (TLBookmarkAsset | TLImageAsset | TLVideoAsset)[];
    /**
     * Create one or more assets.
     *
     * @example
     * ```ts
     * editor.createAssets([...myAssets])
     * ```
     *
     * @param assets - The assets to create.
     *
     * @public
     */
    createAssets(assets: TLAsset[]): this;
    /**
     * Update one or more assets.
     *
     * @example
     * ```ts
     * editor.updateAssets([{ id: 'asset1', name: 'New name' }])
     * ```
     *
     * @param assets - The assets to update.
     *
     * @public
     */
    updateAssets(assets: TLAssetPartial[]): this;
    /**
     * Delete one or more assets.
     *
     * @example
     * ```ts
     * editor.deleteAssets(['asset1', 'asset2'])
     * ```
     *
     * @param ids - The assets to delete.
     *
     * @public
     */
    deleteAssets(assets: TLAsset[] | TLAssetId[]): this;
    /**
     * Get an asset by its id.
     *
     * @example
     * ```ts
     * editor.getAsset('asset1')
     * ```
     *
     * @param asset - The asset (or asset id) to get.
     *
     * @public
     */
    getAsset(asset: TLAsset | TLAssetId): TLAsset | undefined;
    resolveAssetUrl(assetId: null | TLAssetId, context: {
        screenScale?: number;
        shouldResolveToOriginal?: boolean;
    }): Promise<null | string>;
    /**
     * Upload an asset to the store's asset service, returning a URL that can be used to resolve the
     * asset.
     */
    uploadAsset(asset: TLAsset, file: File): Promise<string>;
    private _getShapeGeometryCache;
    /**
     * Get the geometry of a shape.
     *
     * @example
     * ```ts
     * editor.getShapeGeometry(myShape)
     * editor.getShapeGeometry(myShapeId)
     * ```
     *
     * @param shape - The shape (or shape id) to get the geometry for.
     *
     * @public
     */
    getShapeGeometry<T extends Geometry2d>(shape: TLShape | TLShapeId): T;
    /* Excluded from this release type: _getShapeHandlesCache */
    /**
     * Get the handles (if any) for a shape.
     *
     * @example
     * ```ts
     * editor.getShapeHandles(myShape)
     * editor.getShapeHandles(myShapeId)
     * ```
     *
     * @param shape - The shape (or shape id) to get the handles for.
     * @public
     */
    getShapeHandles<T extends TLShape>(shape: T | T['id']): TLHandle[] | undefined;
    /**
     * Get the local transform for a shape as a matrix model. This transform reflects both its
     * translation (x, y) from from either its parent's top left corner, if the shape's parent is
     * another shape, or else from the 0,0 of the page, if the shape's parent is the page; and the
     * shape's rotation.
     *
     * @example
     * ```ts
     * editor.getShapeLocalTransform(myShape)
     * ```
     *
     * @param shape - The shape to get the local transform for.
     *
     * @public
     */
    getShapeLocalTransform(shape: TLShape | TLShapeId): Mat;
    /* Excluded from this release type: _getShapePageTransformCache */
    /**
     * Get the local transform of a shape's parent as a matrix model.
     *
     * @example
     * ```ts
     * editor.getShapeParentTransform(myShape)
     * ```
     *
     * @param shape - The shape (or shape id) to get the parent transform for.
     *
     * @public
     */
    getShapeParentTransform(shape: TLShape | TLShapeId): Mat;
    /**
     * Get the transform of a shape in the current page space.
     *
     * @example
     * ```ts
     * editor.getShapePageTransform(myShape)
     * editor.getShapePageTransform(myShapeId)
     * ```
     *
     * @param shape - The shape (or shape id) to get the page transform for.
     *
     * @public
     */
    getShapePageTransform(shape: TLShape | TLShapeId): Mat;
    /* Excluded from this release type: _getShapePageBoundsCache */
    /**
     * Get the bounds of a shape in the current page space.
     *
     * @example
     * ```ts
     * editor.getShapePageBounds(myShape)
     * editor.getShapePageBounds(myShapeId)
     * ```
     *
     * @param shape - The shape (or shape id) to get the bounds for.
     *
     * @public
     */
    getShapePageBounds(shape: TLShape | TLShapeId): Box | undefined;
    /* Excluded from this release type: _getShapeClipPathCache */
    /**
     * Get the clip path for a shape.
     *
     * @example
     * ```ts
     * const clipPath = editor.getShapeClipPath(shape)
     * const clipPath = editor.getShapeClipPath(shape.id)
     * ```
     *
     * @param shape - The shape (or shape id) to get the clip path for.
     *
     * @returns The clip path or undefined.
     *
     * @public
     */
    getShapeClipPath(shape: TLShape | TLShapeId): string | undefined;
    /* Excluded from this release type: _getShapeMaskCache */
    /**
     * Get the mask (in the current page space) for a shape.
     *
     * @example
     * ```ts
     * const pageMask = editor.getShapeMask(shape.id)
     * ```
     *
     * @param id - The id of the shape to get the mask for.
     *
     * @returns The mask for the shape.
     *
     * @public
     */
    getShapeMask(shape: TLShape | TLShapeId): undefined | VecLike[];
    /**
     * Get the bounds of a shape in the current page space, incorporating any masks. For example, if the
     * shape were the child of a frame and was half way out of the frame, the bounds would be the half
     * of the shape that was in the frame.
     *
     * @example
     * ```ts
     * editor.getShapeMaskedPageBounds(myShape)
     * editor.getShapeMaskedPageBounds(myShapeId)
     * ```
     *
     * @param shape - The shape to get the masked bounds for.
     *
     * @public
     */
    getShapeMaskedPageBounds(shape: TLShape | TLShapeId): Box | undefined;
    /* Excluded from this release type: _getShapeMaskedPageBoundsCache */
    /**
     * Get the ancestors of a shape.
     *
     * @example
     * ```ts
     * const ancestors = editor.getShapeAncestors(myShape)
     * const ancestors = editor.getShapeAncestors(myShapeId)
     * ```
     *
     * @param shape - The shape (or shape id) to get the ancestors for.
     *
     * @public
     */
    getShapeAncestors(shape: TLShape | TLShapeId, acc?: TLShape[]): TLShape[];
    /**
     * Find the first ancestor matching the given predicate
     *
     * @example
     * ```ts
     * const ancestor = editor.findShapeAncestor(myShape)
     * const ancestor = editor.findShapeAncestor(myShape.id)
     * const ancestor = editor.findShapeAncestor(myShape.id, (shape) => shape.type === 'frame')
     * ```
     *
     * @param shape - The shape to check the ancestors for.
     *
     * @public
     */
    findShapeAncestor(shape: TLShape | TLShapeId, predicate: (parent: TLShape) => boolean): TLShape | undefined;
    /**
     * Returns true if the the given shape has the given ancestor.
     *
     * @param shape - The shape.
     * @param ancestorId - The id of the ancestor.
     *
     * @public
     */
    hasAncestor(shape: TLShape | TLShapeId | undefined, ancestorId: TLShapeId): boolean;
    /**
     * Get the common ancestor of two or more shapes that matches a predicate.
     *
     * @param shapes - The shapes (or shape ids) to check.
     * @param predicate - The predicate to match.
     */
    findCommonAncestor(shapes: TLShape[] | TLShapeId[], predicate?: (shape: TLShape) => boolean): TLShapeId | undefined;
    /**
     * Check whether a shape or its parent is locked.
     *
     * @param shape - The shape (or shape id) to check.
     *
     * @public
     */
    isShapeOrAncestorLocked(shape?: TLShape): boolean;
    isShapeOrAncestorLocked(id?: TLShapeId): boolean;
    private _notVisibleShapes;
    /**
     * Get culled shapes.
     *
     * @public
     */
    getCulledShapes(): Set<TLShapeId>;
    /**
     * The bounds of the current page (the common bounds of all of the shapes on the page).
     *
     * @public
     */
    getCurrentPageBounds(): Box | undefined;
    /**
     * Get the top-most selected shape at the given point, ignoring groups.
     *
     * @param point - The point to check.
     *
     * @returns The top-most selected shape at the given point, or undefined if there is no shape at the point.
     */
    getSelectedShapeAtPoint(point: VecLike): TLShape | undefined;
    /**
     * Get the shape at the current point.
     *
     * @param point - The point to check.
     * @param opts - Options for the check: `hitInside` to check if the point is inside the shape, `margin` to check if the point is within a margin of the shape, `hitFrameInside` to check if the point is inside the frame, and `filter` to filter the shapes to check.
     *
     * @returns The shape at the given point, or undefined if there is no shape at the point.
     */
    getShapeAtPoint(point: VecLike, opts?: {
        filter?: ((shape: TLShape) => boolean) | undefined;
        hitFrameInside?: boolean | undefined;
        hitInside?: boolean | undefined;
        hitLabels?: boolean | undefined;
        hitLocked?: boolean | undefined;
        margin?: number | undefined;
        renderingOnly?: boolean | undefined;
    }): TLShape | undefined;
    /**
     * Get the shapes, if any, at a given page point.
     *
     * @example
     * ```ts
     * editor.getShapesAtPoint({ x: 100, y: 100 })
     * editor.getShapesAtPoint({ x: 100, y: 100 }, { hitInside: true, exact: true })
     * ```
     *
     * @param point - The page point to test.
     *
     * @public
     */
    getShapesAtPoint(point: VecLike, opts?: {
        hitInside?: boolean | undefined;
        margin?: number | undefined;
    }): TLShape[];
    /**
     * Test whether a point (in the current page space) will will a shape. This method takes into account masks,
     * such as when a shape is the child of a frame and is partially clipped by the frame.
     *
     * @example
     * ```ts
     * editor.isPointInShape({ x: 100, y: 100 }, myShape)
     * ```
     *
     * @param shape - The shape to test against.
     * @param point - The page point to test (in the current page space).
     * @param hitInside - Whether to count as a hit if the point is inside of a closed shape.
     *
     * @public
     */
    isPointInShape(shape: TLShape | TLShapeId, point: VecLike, opts?: {
        hitInside?: boolean | undefined;
        margin?: number | undefined;
    }): boolean;
    /**
     * Convert a point in the current page space to a point in the local space of a shape. For example, if a
     * shape's page point were `{ x: 100, y: 100 }`, a page point at `{ x: 110, y: 110 }` would be at
     * `{ x: 10, y: 10 }` in the shape's local space.
     *
     * @example
     * ```ts
     * editor.getPointInShapeSpace(myShape, { x: 100, y: 100 })
     * ```
     *
     * @param shape - The shape to get the point in the local space of.
     * @param point - The page point to get in the local space of the shape.
     *
     * @public
     */
    getPointInShapeSpace(shape: TLShape | TLShapeId, point: VecLike): Vec;
    /**
     * Convert a delta in the current page space to a point in the local space of a shape's parent.
     *
     * @example
     * ```ts
     * editor.getPointInParentSpace(myShape.id, { x: 100, y: 100 })
     * ```
     *
     * @param shape - The shape to get the point in the local space of.
     * @param point - The page point to get in the local space of the shape.
     *
     * @public
     */
    getPointInParentSpace(shape: TLShape | TLShapeId, point: VecLike): Vec;
    /**
     * An array containing all of the shapes in the current page.
     *
     * @public
     */
    getCurrentPageShapes(): TLShape[];
    /**
     * An array containing all of the shapes in the current page, sorted in z-index order (accounting
     * for nested shapes): e.g. A, B, BA, BB, C.
     *
     * @public
     */
    getCurrentPageShapesSorted(): TLShape[];
    /**
     * An array containing all of the rendering shapes in the current page, sorted in z-index order (accounting
     * for nested shapes): e.g. A, B, BA, BB, C.
     *
     * @public
     */
    getCurrentPageRenderingShapesSorted(): TLShape[];
    /**
     * Get whether a shape matches the type of a TLShapeUtil.
     *
     * @example
     * ```ts
     * const isArrowShape = isShapeOfType<TLArrowShape>(someShape, 'arrow')
     * ```
     *
     * @param util - the TLShapeUtil constructor to test against
     * @param shape - the shape to test
     *
     * @public
     */
    isShapeOfType<T extends TLUnknownShape>(shape: TLUnknownShape, type: T['type']): shape is T;
    isShapeOfType<T extends TLUnknownShape>(shapeId: TLUnknownShape['id'], type: T['type']): shapeId is T['id'];
    /**
     * Get a shape by its id.
     *
     * @example
     * ```ts
     * editor.getShape('box1')
     * ```
     *
     * @param id - The id of the shape to get.
     *
     * @public
     */
    getShape<T extends TLShape = TLShape>(shape: TLParentId | TLShape): T | undefined;
    /**
     * Get the parent shape for a given shape. Returns undefined if the shape is the direct child of
     * the page.
     *
     * @example
     * ```ts
     * editor.getShapeParent(myShape)
     * ```
     *
     * @public
     */
    getShapeParent(shape?: TLShape | TLShapeId): TLShape | undefined;
    /* Excluded from this release type: getShapeNearestSibling */
    /**
     * Get whether the given shape is the descendant of the given page.
     *
     * @example
     * ```ts
     * editor.isShapeInPage(myShape)
     * editor.isShapeInPage(myShape, 'page1')
     * ```
     *
     * @param shape - The shape to check.
     * @param pageId - The id of the page to check against. Defaults to the current page.
     *
     * @public
     */
    isShapeInPage(shape: TLShape | TLShapeId, pageId?: TLPageId): boolean;
    /**
     * Get the id of the containing page for a given shape.
     *
     * @param shape - The shape to get the page id for.
     *
     * @returns The id of the page that contains the shape, or undefined if the shape is undefined.
     *
     * @public
     */
    getAncestorPageId(shape?: TLShape | TLShapeId): TLPageId | undefined;
    /* Excluded from this release type: _parentIdsToChildIds */
    /**
     * Reparent shapes to a new parent. This operation preserves the shape's current page positions /
     * rotations.
     *
     * @example
     * ```ts
     * editor.reparentShapes([box1, box2], 'frame1')
     * editor.reparentShapes([box1.id, box2.id], 'frame1')
     * editor.reparentShapes([box1.id, box2.id], 'frame1', 4)
     * ```
     *
     * @param shapes - The shapes (or shape ids) of the shapes to reparent.
     * @param parentId - The id of the new parent shape.
     * @param insertIndex - The index to insert the children.
     *
     * @public
     */
    reparentShapes(shapes: TLShape[] | TLShapeId[], parentId: TLParentId, insertIndex?: IndexKey): this;
    /**
     * Get the index above the highest child of a given parent.
     *
     * @param parentId - The id of the parent.
     *
     * @returns The index.
     *
     * @public
     */
    getHighestIndexForParent(parent: TLPage | TLParentId | TLShape): IndexKey;
    /**
     * Get an array of all the children of a shape.
     *
     * @example
     * ```ts
     * editor.getSortedChildIdsForParent('frame1')
     * ```
     *
     * @param parentId - The id of the parent shape.
     *
     * @public
     */
    getSortedChildIdsForParent(parent: TLPage | TLParentId | TLShape): TLShapeId[];
    /**
     * Run a visitor function for all descendants of a shape.
     *
     * @example
     * ```ts
     * editor.visitDescendants('frame1', myCallback)
     * ```
     *
     * @param parentId - The id of the parent shape.
     * @param visitor - The visitor function.
     *
     * @public
     */
    visitDescendants(parent: TLPage | TLParentId | TLShape, visitor: (id: TLShapeId) => false | void): this;
    /**
     * Get the shape ids of all descendants of the given shapes (including the shapes themselves). IDs are returned in z-index order.
     *
     * @param ids - The ids of the shapes to get descendants of.
     *
     * @returns The descendant ids.
     *
     * @public
     */
    getShapeAndDescendantIds(ids: TLShapeId[]): Set<TLShapeId>;
    /**
     * Get the shape that some shapes should be dropped on at a given point.
     *
     * @param point - The point to find the parent for.
     * @param droppingShapes - The shapes that are being dropped.
     *
     * @returns The shape to drop on.
     *
     * @public
     */
    getDroppingOverShape(point: VecLike, droppingShapes?: TLShape[]): TLUnknownShape | undefined;
    /**
     * Get the shape that should be selected when you click on a given shape, assuming there is
     * nothing already selected. It will not return anything higher than or including the current
     * focus layer.
     *
     * @param shape - The shape to get the outermost selectable shape for.
     * @param filter - A function to filter the selectable shapes.
     *
     * @returns The outermost selectable shape.
     *
     * @public
     */
    getOutermostSelectableShape(shape: TLShape | TLShapeId, filter?: (shape: TLShape) => boolean): TLShape;
    private _getBindingsIndexCache;
    /**
     * Get a binding from the store by its ID if it exists.
     */
    getBinding(id: TLBindingId): TLBinding | undefined;
    /**
     * Get all bindings of a certain type _from_ a particular shape. These are the bindings whose
     * `fromId` matched the shape's ID.
     */
    getBindingsFromShape<Binding extends TLUnknownBinding = TLBinding>(shape: TLShape | TLShapeId, type: Binding['type']): Binding[];
    /**
     * Get all bindings of a certain type _to_ a particular shape. These are the bindings whose
     * `toId` matches the shape's ID.
     */
    getBindingsToShape<Binding extends TLUnknownBinding = TLBinding>(shape: TLShape | TLShapeId, type: Binding['type']): Binding[];
    /**
     * Get all bindings involving a particular shape. This includes bindings where the shape is the
     * `fromId` or `toId`. If a type is provided, only bindings of that type are returned.
     */
    getBindingsInvolvingShape<Binding extends TLUnknownBinding = TLBinding>(shape: TLShape | TLShapeId, type?: Binding['type']): Binding[];
    /**
     * Create bindings from a list of partial bindings. You can omit the ID and most props of a
     * binding, but the `type`, `toId`, and `fromId` must all be provided.
     */
    createBindings(partials: TLBindingCreate[]): this;
    /**
     * Create a single binding from a partial. You can omit the ID and most props of a binding, but
     * the `type`, `toId`, and `fromId` must all be provided.
     */
    createBinding<B extends TLBinding = TLBinding>(partial: TLBindingCreate<B>): this;
    /**
     * Update bindings from a list of partial bindings. Each partial must include an ID, which will
     * be used to match the binding to it's existing record. If there is no existing record, that
     * binding is skipped. The changes from the partial are merged into the existing record.
     */
    updateBindings(partials: (null | TLBindingUpdate | undefined)[]): this;
    /**
     * Update a binding from a partial binding. Each partial must include an ID, which will be used
     * to match the binding to it's existing record. If there is no existing record, that binding is
     * skipped. The changes from the partial are merged into the existing record.
     */
    updateBinding<B extends TLBinding = TLBinding>(partial: TLBindingUpdate<B>): this;
    /**
     * Delete several bindings by their IDs. If a binding ID doesn't exist, it's ignored.
     */
    deleteBindings(bindings: (TLBinding | TLBindingId)[], { isolateShapes }?: {
        isolateShapes?: boolean | undefined;
    }): this;
    /**
     * Delete a binding by its ID. If the binding doesn't exist, it's ignored.
     */
    deleteBinding(binding: TLBinding | TLBindingId, opts?: Parameters<this['deleteBindings']>[1]): this;
    canBindShapes({ fromShape, toShape, binding, }: {
        binding: {
            type: TLBinding['type'];
        } | TLBinding | TLBinding['type'];
        fromShape: {
            type: TLShape['type'];
        } | TLShape | TLShape['type'];
        toShape: {
            type: TLShape['type'];
        } | TLShape | TLShape['type'];
    }): boolean;
    /**
     * Rotate shapes by a delta in radians.
     * Note: Currently, this assumes that the shapes are your currently selected shapes.
     *
     * @example
     * ```ts
     * editor.rotateShapesBy(editor.getSelectedShapeIds(), Math.PI)
     * editor.rotateShapesBy(editor.getSelectedShapeIds(), Math.PI / 2)
     * ```
     *
     * @param shapes - The shapes (or shape ids) of the shapes to move.
     * @param delta - The delta in radians to apply to the selection rotation.
     */
    rotateShapesBy(shapes: TLShape[] | TLShapeId[], delta: number): this;
    private getChangesToTranslateShape;
    /**
     * Move shapes by a delta.
     *
     * @example
     * ```ts
     * editor.nudgeShapes(['box1', 'box2'], { x: 8, y: 8 })
     * ```
     *
     * @param shapes - The shapes (or shape ids) to move.
     * @param direction - The direction in which to move the shapes.
     * @param historyOptions - The history options for the change.
     */
    nudgeShapes(shapes: TLShape[] | TLShapeId[], offset: VecLike): this;
    /**
     * Duplicate shapes.
     *
     * @example
     * ```ts
     * editor.duplicateShapes(['box1', 'box2'], { x: 8, y: 8 })
     * editor.duplicateShapes(editor.getSelectedShapes(), { x: 8, y: 8 })
     * ```
     *
     * @param shapes - The shapes (or shape ids) to duplicate.
     * @param offset - The offset (in pixels) to apply to the duplicated shapes.
     *
     * @public
     */
    duplicateShapes(shapes: TLShape[] | TLShapeId[], offset?: VecLike): this;
    /**
     * Move shapes to page.
     *
     * @example
     * ```ts
     * editor.moveShapesToPage(['box1', 'box2'], 'page1')
     * ```
     *
     * @param shapes - The shapes (or shape ids) of the shapes to move.
     * @param pageId - The id of the page where the shapes will be moved.
     *
     * @public
     */
    moveShapesToPage(shapes: TLShape[] | TLShapeId[], pageId: TLPageId): this;
    /**
     * Toggle the lock state of one or more shapes. If there is a mix of locked and unlocked shapes, all shapes will be locked.
     *
     * @param shapes - The shapes (or shape ids) to toggle.
     *
     * @public
     */
    toggleLock(shapes: TLShape[] | TLShapeId[]): this;
    /**
     * Send shapes to the back of the page's object list.
     *
     * @example
     * ```ts
     * editor.sendToBack(['id1', 'id2'])
     * editor.sendToBack(box1, box2)
     * ```
     *
     * @param shapes - The shapes (or shape ids) to move.
     *
     * @public
     */
    sendToBack(shapes: TLShape[] | TLShapeId[]): this;
    /**
     * Send shapes backward in the page's object list.
     *
     * @example
     * ```ts
     * editor.sendBackward(['id1', 'id2'])
     * editor.sendBackward([box1, box2])
     * ```
     *
     * @param shapes - The shapes (or shape ids) to move.
     *
     * @public
     */
    sendBackward(shapes: TLShape[] | TLShapeId[]): this;
    /**
     * Bring shapes forward in the page's object list.
     *
     * @example
     * ```ts
     * editor.bringForward(['id1', 'id2'])
     * editor.bringForward(box1,  box2)
     * ```
     *
     * @param shapes - The shapes (or shape ids) to move.
     *
     * @public
     */
    bringForward(shapes: TLShape[] | TLShapeId[]): this;
    /**
     * Bring shapes to the front of the page's object list.
     *
     * @example
     * ```ts
     * editor.bringToFront(['id1', 'id2'])
     * editor.bringToFront([box1, box2])
     * ```
     *
     * @param shapes - The shapes (or shape ids) to move.
     *
     * @public
     */
    bringToFront(shapes: TLShape[] | TLShapeId[]): this;
    /**
     * Flip shape positions.
     *
     * @example
     * ```ts
     * editor.flipShapes([box1, box2], 'horizontal', 32)
     * editor.flipShapes(editor.getSelectedShapeIds(), 'horizontal', 32)
     * ```
     *
     * @param shapes - The ids of the shapes to flip.
     * @param operation - Whether to flip horizontally or vertically.
     *
     * @public
     */
    flipShapes(shapes: TLShape[] | TLShapeId[], operation: 'horizontal' | 'vertical'): this;
    /**
     * Stack shape.
     *
     * @example
     * ```ts
     * editor.stackShapes([box1, box2], 'horizontal', 32)
     * editor.stackShapes(editor.getSelectedShapeIds(), 'horizontal', 32)
     * ```
     *
     * @param shapes - The shapes (or shape ids) to stack.
     * @param operation - Whether to stack horizontally or vertically.
     * @param gap - The gap to leave between shapes.
     *
     * @public
     */
    stackShapes(shapes: TLShape[] | TLShapeId[], operation: 'horizontal' | 'vertical', gap: number): this;
    /**
     * Pack shapes into a grid centered on their current position. Based on potpack (https://github.com/mapbox/potpack).
     *
     * @example
     * ```ts
     * editor.packShapes([box1, box2], 32)
     * editor.packShapes(editor.getSelectedShapeIds(), 32)
     * ```
     *
     *
     * @param shapes - The shapes (or shape ids) to pack.
     * @param gap - The padding to apply to the packed shapes. Defaults to 16.
     */
    packShapes(shapes: TLShape[] | TLShapeId[], gap: number): this;
    /**
     * Align shape positions.
     *
     * @example
     * ```ts
     * editor.alignShapes([box1, box2], 'left')
     * editor.alignShapes(editor.getSelectedShapeIds(), 'left')
     * ```
     *
     * @param shapes - The shapes (or shape ids) to align.
     * @param operation - The align operation to apply.
     *
     * @public
     */
    alignShapes(shapes: TLShape[] | TLShapeId[], operation: 'bottom' | 'center-horizontal' | 'center-vertical' | 'left' | 'right' | 'top'): this;
    /**
     * Distribute shape positions.
     *
     * @example
     * ```ts
     * editor.distributeShapes([box1, box2], 'horizontal')
     * editor.distributeShapes(editor.getSelectedShapeIds(), 'horizontal')
     * ```
     *
     * @param shapes - The shapes (or shape ids) to distribute.
     * @param operation - Whether to distribute shapes horizontally or vertically.
     *
     * @public
     */
    distributeShapes(shapes: TLShape[] | TLShapeId[], operation: 'horizontal' | 'vertical'): this;
    /**
     * Stretch shape sizes and positions to fill their common bounding box.
     *
     * @example
     * ```ts
     * editor.stretchShapes([box1, box2], 'horizontal')
     * editor.stretchShapes(editor.getSelectedShapeIds(), 'horizontal')
     * ```
     *
     * @param shapes - The shapes (or shape ids) to stretch.
     * @param operation - Whether to stretch shapes horizontally or vertically.
     *
     * @public
     */
    stretchShapes(shapes: TLShape[] | TLShapeId[], operation: 'horizontal' | 'vertical'): this;
    /**
     * Resize a shape.
     *
     * @param id - The id of the shape to resize.
     * @param scale - The scale factor to apply to the shape.
     * @param options - Additional options.
     *
     * @public
     */
    resizeShape(shape: TLShape | TLShapeId, scale: VecLike, options?: TLResizeShapeOptions): this;
    /* Excluded from this release type: _scalePagePoint */
    /* Excluded from this release type: _resizeUnalignedShape */
    /**
     * Get the initial meta value for a shape.
     *
     * @example
     * ```ts
     * editor.getInitialMetaForShape = (shape) => {
     *   if (shape.type === 'note') {
     *     return { createdBy: myCurrentUser.id }
     *   }
     * }
     * ```
     *
     * @param shape - The shape to get the initial meta for.
     *
     * @public
     */
    getInitialMetaForShape(_shape: TLShape): JsonObject;
    /**
     * Create a single shape.
     *
     * @example
     * ```ts
     * editor.createShape(myShape)
     * editor.createShape({ id: 'box1', type: 'text', props: { text: "ok" } })
     * ```
     *
     * @param shape - The shape (or shape partial) to create.
     *
     * @public
     */
    createShape<T extends TLUnknownShape>(shape: OptionalKeys<TLShapePartial<T>, 'id'>): this;
    /**
     * Create shapes.
     *
     * @example
     * ```ts
     * editor.createShapes([myShape])
     * editor.createShapes([{ id: 'box1', type: 'text', props: { text: "ok" } }])
     * ```
     *
     * @param shapes - The shapes (or shape partials) to create.
     * @param select - Whether to select the created shapes. Defaults to false.
     *
     * @public
     */
    createShapes<T extends TLUnknownShape>(shapes: OptionalKeys<TLShapePartial<T>, 'id'>[]): this;
    private animatingShapes;
    /**
     * Animate a shape.
     *
     * @example
     * ```ts
     * editor.animateShape({ id: 'box1', type: 'box', x: 100, y: 100 })
     * editor.animateShape({ id: 'box1', type: 'box', x: 100, y: 100 }, { animation: { duration: 100, ease: t => t*t } })
     * ```
     *
     * @param partial - The shape partial to update.
     * @param options - The animation's options.
     *
     * @public
     */
    animateShape(partial: null | TLShapePartial | undefined, opts?: Partial<{
        animation: Partial<{
            duration: number;
            easing: (t: number) => number;
        }>;
        force: boolean;
        immediate: boolean;
        reset: boolean;
    }>): this;
    /**
     * Animate shapes.
     *
     * @example
     * ```ts
     * editor.animateShapes([{ id: 'box1', type: 'box', x: 100, y: 100 }])
     * editor.animateShapes([{ id: 'box1', type: 'box', x: 100, y: 100 }], { animation: { duration: 100, ease: t => t*t } })
     * ```
     *
     * @param partials - The shape partials to update.
     * @param options - The animation's options.
     *
     * @public
     */
    animateShapes(partials: (null | TLShapePartial | undefined)[], opts?: Partial<{
        animation: Partial<{
            duration: number;
            easing: (t: number) => number;
        }>;
        force: boolean;
        immediate: boolean;
        reset: boolean;
    }>): this;
    /**
     * Create a group containing the provided shapes.
     *
     * @example
     * ```ts
     * editor.groupShapes([myShape, myOtherShape])
     * editor.groupShapes([myShape, myOtherShape], { groupId: myGroupId, select: false })
     * ```
     *
     * @param shapes - The shapes (or shape ids) to group. Defaults to the selected shapes.
     * @param options - An options object.
     *
     * @public
     */
    groupShapes(shapes: TLShape[], options?: Partial<{
        groupId: TLShapeId;
        select: boolean;
    }>): this;
    groupShapes(ids: TLShapeId[], options?: Partial<{
        groupId: TLShapeId;
        select: boolean;
    }>): this;
    /**
     * Ungroup some shapes.
     *
     * @example
     * ```ts
     * editor.ungroupShapes([myGroup, myOtherGroup])
     * editor.ungroupShapes([myGroup], { select: false })
     * ```
     *
     * @param shapes - The group shapes (or shape ids) to ungroup.
     * @param options - An options object.
     *
     * @public
     */
    ungroupShapes(ids: TLShapeId[], options?: Partial<{
        select: boolean;
    }>): this;
    ungroupShapes(shapes: TLShape[], options?: Partial<{
        select: boolean;
    }>): this;
    /**
     * Update a shape using a partial of the shape.
     *
     * @example
     * ```ts
     * editor.updateShape({ id: 'box1', type: 'geo', props: { w: 100, h: 100 } })
     * ```
     *
     * @param partial - The shape partial to update.
     *
     * @public
     */
    updateShape<T extends TLUnknownShape>(partial: null | TLShapePartial<T> | undefined): this;
    /**
     * Update shapes using partials of each shape.
     *
     * @example
     * ```ts
     * editor.updateShapes([{ id: 'box1', type: 'geo', props: { w: 100, h: 100 } }])
     * ```
     *
     * @param partials - The shape partials to update.
     *
     * @public
     */
    updateShapes<T extends TLUnknownShape>(partials: (null | TLShapePartial<T> | undefined)[]): this;
    /* Excluded from this release type: _updateShapes */
    /* Excluded from this release type: _getUnlockedShapeIds */
    /**
     * Delete shapes.
     *
     * @example
     * ```ts
     * editor.deleteShapes(['box1', 'box2'])
     * ```
     *
     * @param ids - The ids of the shapes to delete.
     *
     * @public
     */
    deleteShapes(ids: TLShapeId[]): this;
    deleteShapes(shapes: TLShape[]): this;
    /**
     * Delete a shape.
     *
     * @example
     * ```ts
     * editor.deleteShape(shape.id)
     * ```
     *
     * @param id - The id of the shape to delete.
     *
     * @public
     */
    deleteShape(id: TLShapeId): this;
    deleteShape(shape: TLShape): this;
    /* Excluded from this release type: _extractSharedStyles */
    /* Excluded from this release type: _getSelectionSharedStyles */
    /**
     * Get the style for the next shape.
     *
     * @example
     * ```ts
     * const color = editor.getStyleForNextShape(DefaultColorStyle)
     * ```
     *
     * @param style - The style to get.
     *
     * @public */
    getStyleForNextShape<T>(style: StyleProp<T>): T;
    getShapeStyleIfExists<T>(shape: TLShape, style: StyleProp<T>): T | undefined;
    /**
     * A map of all the current styles either in the current selection, or that are relevant to the
     * current tool.
     *
     * @example
     * ```ts
     * const color = editor.getSharedStyles().get(DefaultColorStyle)
     * if (color && color.type === 'shared') {
     *   print('All selected shapes have the same color:', color.value)
     * }
     * ```
     *
     * @public
     */
    getSharedStyles(): ReadonlySharedStyleMap;
    /**
     * Get the currently selected shared opacity.
     * If any shapes are selected, this returns the shared opacity of the selected shapes.
     * Otherwise, this returns the chosen opacity for the next shape.
     *
     * @public
     */
    getSharedOpacity(): SharedStyle<number>;
    /**
     * Set the opacity for the next shapes. This will effect subsequently created shapes.
     *
     * @example
     * ```ts
     * editor.setOpacityForNextShapes(0.5)
     * ```
     *
     * @param opacity - The opacity to set. Must be a number between 0 and 1 inclusive.
     * @param historyOptions - The history options for the change.
     */
    setOpacityForNextShapes(opacity: number, historyOptions?: TLHistoryBatchOptions): this;
    /**
     * Set the current opacity. This will effect any selected shapes.
     *
     * @example
     * ```ts
     * editor.setOpacityForSelectedShapes(0.5)
     * ```
     *
     * @param opacity - The opacity to set. Must be a number between 0 and 1 inclusive.
     */
    setOpacityForSelectedShapes(opacity: number): this;
    /**
     * Set the value of a {@link @tldraw/tlschema#StyleProp} for the next shapes. This change will be applied to subsequently created shapes.
     *
     * @example
     * ```ts
     * editor.setStyleForNextShapes(DefaultColorStyle, 'red')
     * editor.setStyleForNextShapes(DefaultColorStyle, 'red', { ephemeral: true })
     * ```
     *
     * @param style - The style to set.
     * @param value - The value to set.
     * @param historyOptions - The history options for the change.
     *
     * @public
     */
    setStyleForNextShapes<T>(style: StyleProp<T>, value: T, historyOptions?: TLHistoryBatchOptions): this;
    /**
     * Set the value of a {@link @tldraw/tlschema#StyleProp}. This change will be applied to the currently selected shapes.
     *
     * @example
     * ```ts
     * editor.setStyleForSelectedShapes(DefaultColorStyle, 'red')
     * ```
     *
     * @param style - The style to set.
     * @param value - The value to set.
     * @param historyOptions - The history options for the change.
     *
     * @public
     */
    setStyleForSelectedShapes<S extends StyleProp<any>>(style: S, value: StylePropValue<S>): this;
    /* Excluded from this release type: externalAssetContentHandlers */
    /**
     * Register an external asset handler. This handler will be called when the editor needs to
     * create an asset for some external content, like an image/video file or a bookmark URL. For
     * example, the 'file' type handler will be called when a user drops an image onto the canvas.
     *
     * The handler should extract any relevant metadata for the asset, upload it to blob storage
     * using {@link Editor.uploadAsset} if needed, and return the asset with the metadata & uploaded
     * URL.
     *
     * @example
     * ```ts
     * editor.registerExternalAssetHandler('file', myHandler)
     * ```
     *
     * @param type - The type of external content.
     * @param handler - The handler to use for this content type.
     *
     * @public
     */
    registerExternalAssetHandler<T extends TLExternalAssetContent['type']>(type: T, handler: ((info: TLExternalAssetContent & {
        type: T;
    }) => Promise<TLAsset>) | null): this;
    /**
     * Get an asset for an external asset content type.
     *
     * @example
     * ```ts
     * const asset = await editor.getAssetForExternalContent({ type: 'file', file: myFile })
     * const asset = await editor.getAssetForExternalContent({ type: 'url', url: myUrl })
     * ```
     *
     * @param info - Info about the external content.
     * @returns The asset.
     */
    getAssetForExternalContent(info: TLExternalAssetContent): Promise<TLAsset | undefined>;
    hasExternalAssetHandler(type: TLExternalAssetContent['type']): boolean;
    /* Excluded from this release type: externalContentHandlers */
    /**
     * Register an external content handler. This handler will be called when the editor receives
     * external content of the provided type. For example, the 'image' type handler will be called
     * when a user drops an image onto the canvas.
     *
     * @example
     * ```ts
     * editor.registerExternalContentHandler('text', myHandler)
     * ```
     *
     * @param type - The type of external content.
     * @param handler - The handler to use for this content type.
     *
     * @public
     */
    registerExternalContentHandler<T extends TLExternalContent['type']>(type: T, handler: ((info: T extends TLExternalContent['type'] ? TLExternalContent & {
        type: T;
    } : TLExternalContent) => void) | null): this;
    /**
     * Handle external content, such as files, urls, embeds, or plain text which has been put into the app, for example by pasting external text or dropping external images onto canvas.
     *
     * @param info - Info about the external content.
     */
    putExternalContent(info: TLExternalContent): Promise<void>;
    /**
     * Get content that can be exported for the given shape ids.
     *
     * @param shapes - The shapes (or shape ids) to get content for.
     *
     * @returns The exported content.
     *
     * @public
     */
    getContentFromCurrentPage(shapes: TLShape[] | TLShapeId[]): TLContent | undefined;
    resolveAssetsInContent(content: TLContent | undefined): Promise<TLContent | undefined>;
    /**
     * Place content into the editor.
     *
     * @param content - The content.
     * @param options - Options for placing the content.
     *
     * @public
     */
    putContentOntoCurrentPage(content: TLContent, options?: {
        point?: VecLike;
        preserveIds?: boolean;
        preservePosition?: boolean;
        select?: boolean;
    }): this;
    /**
     * Get an exported SVG element of the given shapes.
     *
     * @param ids - The shapes (or shape ids) to export.
     * @param opts - Options for the export.
     *
     * @returns The SVG element.
     *
     * @public
     */
    getSvgElement(shapes: TLShape[] | TLShapeId[], opts?: TLSvgOptions): Promise<{
        height: number;
        svg: SVGSVGElement;
        width: number;
    } | undefined>;
    /**
     * Get an exported SVG string of the given shapes.
     *
     * @param ids - The shapes (or shape ids) to export.
     * @param opts - Options for the export.
     *
     * @returns The SVG element.
     *
     * @public
     */
    getSvgString(shapes: TLShape[] | TLShapeId[], opts?: TLSvgOptions): Promise<{
        height: number;
        svg: string;
        width: number;
    } | undefined>;
    /** @deprecated Use {@link Editor.getSvgString} or {@link Editor.getSvgElement} instead. */
    getSvg(shapes: TLShape[] | TLShapeId[], opts?: TLSvgOptions): Promise<SVGSVGElement | undefined>;
    /**
     * The app's current input state.
     *
     * @public
     */
    inputs: {
        /** A set containing the currently pressed buttons. */
        buttons: Set<number>;
        /** A set containing the currently pressed keys. */
        keys: Set<string>;
        /** The most recent pointer down's position in screen space. */
        originScreenPoint: Vec;
        /** The most recent pointer down's position in the current page space. */
        originPagePoint: Vec;
        /** The most recent pointer position in screen space. */
        currentScreenPoint: Vec;
        /** The most recent pointer position in the current page space. */
        currentPagePoint: Vec;
        /** The previous pointer position in screen space. */
        previousScreenPoint: Vec;
        /** The previous pointer position in the current page space. */
        previousPagePoint: Vec;
        /** Velocity of mouse pointer, in pixels per millisecond */
        pointerVelocity: Vec;
        /** Whether the alt or option key is currently pressed. */
        altKey: boolean;
        /** Whether the control or command key is currently pressed. */
        ctrlKey: boolean;
        /** Whether the input is from a pe. */
        isPen: boolean;
        /** Whether the shift key is currently pressed. */
        shiftKey: boolean;
        /** Whether the user is dragging. */
        isDragging: boolean;
        /** Whether the user is editing. */
        isEditing: boolean;
        /** Whether the user is panning. */
        isPanning: boolean;
        /** Whether the user is pinching. */
        isPinching: boolean;
        /** Whether the user is pointing. */
        isPointing: boolean;
    };
    /**
     * Update the input points from a pointer, pinch, or wheel event.
     *
     * @param info - The event info.
     */
    private _updateInputsFromEvent;
    /**
     * Dispatch a cancel event.
     *
     * @example
     * ```ts
     * editor.cancel()
     * ```
     *
     * @public
     */
    cancel(): this;
    /**
     * Dispatch an interrupt event.
     *
     * @example
     * ```ts
     * editor.interrupt()
     * ```
     *
     * @public
     */
    interrupt(): this;
    /**
     * Dispatch a complete event.
     *
     * @example
     * ```ts
     * editor.complete()
     * ```
     *
     * @public
     */
    complete(): this;
    /**
     * Puts the editor into focused mode.
     *
     * This makes the editor eligible to receive keyboard events and some pointer events (move, wheel).
     *
     * @example
     * ```ts
     * editor.focus()
     * ```
     *
     * By default this also dispatches a 'focus' event to the container element. To prevent this, pass `focusContainer: false`.
     *
     * @example
     * ```ts
     * editor.focus({ focusContainer: false })
     * ```
     *
     * @public
     */
    focus({ focusContainer }?: {
        focusContainer?: boolean | undefined;
    }): this;
    /**
     * Switches off the editor's focused mode.
     *
     * This makes the editor ignore keyboard events and some pointer events (move, wheel).
     *
     * @example
     * ```ts
     * editor.blur()
     * ```
     * By default this also dispatches a 'blur' event to the container element. To prevent this, pass `blurContainer: false`.
     *
     * @example
     * ```ts
     * editor.blur({ blurContainer: false })
     * ```
     *
     * @public
     */
    blur({ blurContainer }?: {
        blurContainer?: boolean | undefined;
    }): this;
    /**
     * @public
     * @returns true if the editor is focused
     */
    getIsFocused(): boolean;
    /**
     * @public
     * @returns a snapshot of the store's UI and document state
     */
    getSnapshot(): TLEditorSnapshot;
    /**
     * Loads a snapshot into the editor.
     * @param snapshot - the snapshot to load
     * @returns
     */
    loadSnapshot(snapshot: Partial<TLEditorSnapshot> | TLStoreSnapshot): this;
    /* Excluded from this release type: _clickManager */
    /**
     * Prevent a double click event from firing the next time the user clicks
     *
     * @public
     */
    cancelDoubleClick(): void;
    /* Excluded from this release type: _prevCursor */
    /* Excluded from this release type: _shiftKeyTimeout */
    /* Excluded from this release type: _setShiftKeyTimeout */
    /* Excluded from this release type: _altKeyTimeout */
    /* Excluded from this release type: _setAltKeyTimeout */
    /* Excluded from this release type: _ctrlKeyTimeout */
    /* Excluded from this release type: _setCtrlKeyTimeout */
    /* Excluded from this release type: _restoreToolId */
    /* Excluded from this release type: _pinchStart */
    /* Excluded from this release type: _didPinch */
    /* Excluded from this release type: _selectedShapeIdsAtPointerDown */
    /* Excluded from this release type: _longPressTimeout */
    /* Excluded from this release type: capturedPointerId */
    /* Excluded from this release type: performanceTracker */
    /* Excluded from this release type: performanceTrackerTimeout */
    /**
     * Dispatch an event to the editor.
     *
     * @example
     * ```ts
     * editor.dispatch(myPointerEvent)
     * ```
     *
     * @param info - The event info.
     *
     * @public
     */
    dispatch: (info: TLEventInfo) => this;
    private _pendingEventsForNextTick;
    private _flushEventsForTick;
    private _flushEventForTick;
    /* Excluded from this release type: maybeTrackPerformance */
}

export { EffectScheduler }

/** @public */
export declare class Ellipse2d extends Geometry2d {
    config: Omit<Geometry2dOptions, 'isClosed'> & {
        height: number;
        width: number;
    };
    w: number;
    h: number;
    constructor(config: Omit<Geometry2dOptions, 'isClosed'> & {
        height: number;
        width: number;
    });
    _edges?: Edge2d[];
    get edges(): Edge2d[];
    getVertices(): any[];
    nearestPoint(A: Vec): Vec;
    hitTestLineSegment(A: Vec, B: Vec): boolean;
    getBounds(): Box;
    getLength(): number;
    getSvgPathData(first?: boolean): string;
}

export { EMPTY_ARRAY }

/** @public */
export declare class EnvironmentManager {
    editor: Editor;
    constructor(editor: Editor);
    /**
     * Whether the editor is running in Safari.
     *
     * @public
     */
    readonly isSafari: boolean;
    /**
     * Whether the editor is running on iOS.
     *
     * @public
     */
    readonly isIos: boolean;
    /**
     * Whether the editor is running on iOS.
     *
     * @public
     */
    readonly isChromeForIos: boolean;
    /**
     * Whether the editor is running on Firefox.
     *
     * @public
     */
    readonly isFirefox: boolean;
    /**
     * Whether the editor is running on Android.
     *
     * @public
     */
    readonly isAndroid: boolean;
}

/** @public */
export declare class ErrorBoundary extends React_3.Component<React_3.PropsWithRef<React_3.PropsWithChildren<TLErrorBoundaryProps>>, {
    error: Error | null;
}> {
    static getDerivedStateFromError(error: Error): {
        error: Error;
    };
    state: {
        error: null;
    };
    componentDidCatch(error: unknown): void;
    render(): boolean | JSX_2.Element | Iterable<React_3.ReactNode> | null | number | string | undefined;
}

/** @public @react */
export declare function ErrorScreen({ children }: LoadingScreenProps): JSX_2.Element;

/** @public */
export declare const EVENT_NAME_MAP: Record<Exclude<TLEventName, TLPinchEventName>, keyof TLEventHandlers>;

/* Excluded from this release type: extractSessionStateFromLegacySnapshot */

/* Excluded from this release type: featureFlags */

/** @public */
export declare interface GapsSnapIndicator {
    id: string;
    type: 'gaps';
    direction: 'horizontal' | 'vertical';
    gaps: Array<{
        endEdge: [VecLike, VecLike];
        startEdge: [VecLike, VecLike];
    }>;
}

/** @public */
export declare abstract class Geometry2d {
    isFilled: boolean;
    isClosed: boolean;
    isLabel: boolean;
    debugColor?: string;
    ignore?: boolean;
    constructor(opts: Geometry2dOptions);
    abstract getVertices(): Vec[];
    abstract nearestPoint(point: Vec): Vec;
    hitTestPoint(point: Vec, margin?: number, hitInside?: boolean): boolean;
    distanceToPoint(point: Vec, hitInside?: boolean): number;
    distanceToLineSegment(A: Vec, B: Vec): number;
    hitTestLineSegment(A: Vec, B: Vec, distance?: number): boolean;
    nearestPointOnLineSegment(A: Vec, B: Vec): Vec;
    isPointInBounds(point: Vec, margin?: number): boolean;
    private _vertices;
    get vertices(): Vec[];
    getBounds(): Box;
    private _bounds;
    get bounds(): Box;
    get center(): Vec;
    private _area;
    get area(): number;
    getArea(): number;
    toSimpleSvgPath(): string;
    private _length?;
    get length(): number;
    getLength(): number;
    abstract getSvgPathData(first: boolean): string;
}

/** @public */
export declare interface Geometry2dOptions {
    isFilled: boolean;
    isClosed: boolean;
    isLabel?: boolean;
    debugColor?: string;
    ignore?: boolean;
}

/**
 * Get the measure of an arc.
 *
 * @param A - The angle from center to arc's start point (A) on the circle
 * @param B - The angle from center to arc's end point (B) on the circle
 * @param sweepFlag - 1 if the arc is clockwise, 0 if counter-clockwise
 * @param largeArcFlag - 1 if the arc is greater than 180 degrees, 0 if less than 180 degrees
 *
 * @returns The measure of the arc, negative if counter-clockwise
 *
 * @public
 */
export declare function getArcMeasure(A: number, B: number, sweepFlag: number, largeArcFlag: number): number;

/** @public */
export declare function getCursor(cursor: TLCursorType, rotation?: number, color?: string): string;

/** @public */
export declare function getDefaultCdnBaseUrl(): string;

/** @public */
export declare function getFreshUserPreferences(): TLUserPreferences;

/**
 * Get an incremented name (e.g. New page (2)) from a name (e.g. New page), based on an array of
 * existing names.
 *
 * @param name - The name to increment.
 * @param others - The array of existing names.
 * @public
 */
export declare function getIncrementedName(name: string, others: string[]): string;

/** @public */
export declare function getPointerInfo(e: PointerEvent | React.PointerEvent): {
    altKey: boolean;
    button: number;
    ctrlKey: boolean;
    isPen: boolean;
    point: {
        x: number;
        y: number;
        z: number;
    };
    pointerId: number;
    shiftKey: boolean;
};

/**
 * Returns the t value of the point on the arc.
 *
 * @param mAB - The measure of the arc from A to B, negative if counter-clockwise
 * @param A - The angle from center to arc's start point (A) on the circle
 * @param B - The angle from center to arc's end point (B) on the circle
 * @param P - The angle on the circle (P) to find the t value for
 *
 * @returns The t value of the point on the arc, with 0 being the start and 1 being the end
 *
 * @public
 */
export declare function getPointInArcT(mAB: number, A: number, B: number, P: number): number;

/**
 * Get a point on the perimeter of a circle.
 *
 * @param center - The center of the circle.
 * @param r - The radius of the circle.
 * @param a - The angle in radians.
 * @public
 */
export declare function getPointOnCircle(center: VecLike, r: number, a: number): Vec;

/** @public */
export declare function getPointsOnArc(startPoint: VecLike, endPoint: VecLike, center: null | VecLike, radius: number, numPoints: number): Vec[];

/** @public */
export declare function getPolygonVertices(width: number, height: number, sides: number): Vec[];

/* Excluded from this release type: getRotationSnapshot */

/** @public */
export declare function getSnapshot(store: TLStore): TLEditorSnapshot;

/**
 * Turn an array of points into a path of quadradic curves.
 *
 * @param points - The points returned from perfect-freehand
 * @param closed - Whether the stroke is closed
 *
 * @public
 */
export declare function getSvgPathFromPoints(points: VecLike[], closed?: boolean): string;

/** @public */
export declare function getUserPreferences(): TLUserPreferences;

/** @public */
export declare class Group2d extends Geometry2d {
    children: Geometry2d[];
    ignoredChildren: Geometry2d[];
    constructor(config: Omit<Geometry2dOptions, 'isClosed' | 'isFilled'> & {
        children: Geometry2d[];
    });
    getVertices(): Vec[];
    nearestPoint(point: Vec): Vec;
    distanceToPoint(point: Vec, hitInside?: boolean): number;
    hitTestPoint(point: Vec, margin: number, hitInside: boolean): boolean;
    hitTestLineSegment(A: Vec, B: Vec, zoom: number): boolean;
    getArea(): number;
    toSimpleSvgPath(): string;
    getLength(): number;
    getSvgPathData(): string;
}

/** @public */
export declare class GroupShapeUtil extends ShapeUtil<TLGroupShape> {
    static type: "group";
    static props: RecordProps<TLGroupShape>;
    static migrations: TLPropsMigrations;
    hideSelectionBoundsFg: () => boolean;
    canBind: () => boolean;
    getDefaultProps(): TLGroupShape['props'];
    getGeometry(shape: TLGroupShape): Geometry2d;
    component(shape: TLGroupShape): JSX_2.Element | null;
    indicator(shape: TLGroupShape): JSX_2.Element;
    onChildrenChange: TLOnChildrenChangeHandler<TLGroupShape>;
}

/** @public */
export declare const HALF_PI: number;

/**
 * When dragging a handle, users can snap the handle to key geometry on other nearby shapes.
 * Customize how handles snap to a shape by returning this from
 * {@link ShapeUtil.getHandleSnapGeometry}.
 *
 * Any co-ordinates here should be in the shape's local space.
 *
 * @public
 */
export declare interface HandleSnapGeometry {
    /**
     * A `Geometry2d` that describe the outline of the shape that the handle will snap to - fills
     * are ignored. By default, this is the same geometry returned by {@link ShapeUtil.getGeometry}.
     * Set this to `null` to disable handle snapping to this shape's outline.
     */
    outline?: Geometry2d | null;
    /**
     * Key points on the shape that the handle will snap to. For example, the corners of a
     * rectangle, or the centroid of a triangle. By default, no points are used.
     */
    points?: VecModel[];
    /**
     * By default, handles can't snap to their own shape because moving the handle might change the
     * snapping location which can cause feedback loops. You can override this by returning a
     * version of `outline` that won't be affected by the current handle's position to use for
     * self-snapping.
     */
    getSelfSnapOutline?(handle: TLHandle): Geometry2d | null;
    /**
     * By default, handles can't snap to their own shape because moving the handle might change the
     * snapping location which can cause feedback loops. You can override this by returning a
     * version of `points` that won't be affected by the current handle's position to use for
     * self-snapping.
     */
    getSelfSnapPoints?(handle: TLHandle): VecModel[];
}

/** @public */
export declare class HandleSnaps {
    readonly manager: SnapManager;
    readonly editor: Editor;
    constructor(manager: SnapManager);
    private getSnapGeometryCache;
    private iterateSnapPointsInPageSpace;
    private iterateSnapOutlines;
    private getHandleSnapPosition;
    snapHandle({ currentShapeId, handle, }: {
        currentShapeId: TLShapeId;
        handle: TLHandle;
    }): null | SnapData;
}

/**
 * Clear the database of all data associated with tldraw.
 *
 * @public */
export declare function hardReset({ shouldReload }?: {
    shouldReload?: boolean | undefined;
}): Promise<void>;

/** @public */
export declare function hardResetEditor(): void;

/** @public */
export declare class HistoryManager<R extends UnknownRecord> {
    private readonly store;
    readonly dispose: () => void;
    private state;
    private readonly pendingDiff;
    private stacks;
    private readonly annotateError;
    constructor(opts: {
        annotateError?: (error: unknown) => void;
        store: Store<R>;
    });
    private flushPendingDiff;
    getNumUndos(): number;
    getNumRedos(): number;
    /* Excluded from this release type: _isInBatch */
    batch: (fn: () => void, opts?: TLHistoryBatchOptions) => this;
    private _undo;
    undo: () => this;
    redo: () => this;
    bail: () => this;
    bailToMark: (id: string) => this;
    squashToMark: (id: string) => this;
    mark: (id?: string) => string;
    clear(): void;
    /* Excluded from this release type: debug */
}

/** @public @react */
export declare function HTMLContainer({ children, className, ...rest }: HTMLContainerProps): JSX_2.Element;

/** @public */
export declare type HTMLContainerProps = React_3.HTMLAttributes<HTMLDivElement>;

/** @public */
export declare const inlineBase64AssetStore: TLAssetStore;

/**
 * Find the intersections between a circle and a circle.
 *
 * @param c1 - The first circle's center.
 * @param r1 - The first circle's radius.
 * @param c2 - The second circle's center.
 * @param r2 - The second circle's radius.
 * @public
 */
export declare function intersectCircleCircle(c1: VecLike, r1: number, c2: VecLike, r2: number): Vec[];

/**
 * Find the intersections between a circle and a bounding box.
 *
 * @param c - The circle's center.
 * @param r - The circle's radius.
 * @param points - The points in the polygon.
 * @public
 */
export declare function intersectCirclePolygon(c: VecLike, r: number, points: VecLike[]): null | VecLike[];

/**
 * Find the intersections between a circle and a bounding box.
 *
 * @param c - The circle's center.
 * @param r - The circle's radius.
 * @param points - The points in the polyline.
 * @public
 */
export declare function intersectCirclePolyline(c: VecLike, r: number, points: VecLike[]): null | VecLike[];

/**
 * Find the intersections between a line segment and a circle.
 *
 * @param a1 - The segment's first point.
 * @param a2 - The segment's second point.
 * @param c - The circle's center.
 * @param r - The circle's radius.
 * @public
 */
export declare function intersectLineSegmentCircle(a1: VecLike, a2: VecLike, c: VecLike, r: number): null | VecLike[];

/**
 * Find the intersection between a line segment and a line segment.
 *
 * @param a1 - The first segment's first point.
 * @param a2 - The first segment's second point.
 * @param b1 - The second segment's first point.
 * @param b2 - The second segment's second point.
 * @public
 */
export declare function intersectLineSegmentLineSegment(a1: VecLike, a2: VecLike, b1: VecLike, b2: VecLike): null | Vec;

/**
 * Find the intersections between a line segment and a closed polygon.
 *
 * @param a1 - The segment's first point.
 * @param a2 - The segment's second point.
 * @param points - The points in the polygon.
 * @public
 */
export declare function intersectLineSegmentPolygon(a1: VecLike, a2: VecLike, points: VecLike[]): null | VecLike[];

/**
 * Find the intersections between a line segment and a polyline.
 *
 * @param a1 - The segment's first point.
 * @param a2 - The segment's second point.
 * @param points - The points in the polyline.
 * @public
 */
export declare function intersectLineSegmentPolyline(a1: VecLike, a2: VecLike, points: VecLike[]): null | VecLike[];

/**
 * Find the intersections between a polygon and a bounding box.
 *
 * @public
 */
export declare function intersectPolygonBounds(points: VecLike[], bounds: Box): null | VecLike[];

/**
 * Create a new convex polygon as the intersection of two convex polygons.
 *
 * @param polygonA - An array of points representing the first polygon.
 * @param polygonB - An array of points representing the second polygon.
 * @public
 */
export declare function intersectPolygonPolygon(polygonA: VecLike[], polygonB: VecLike[]): null | VecLike[];

/**
 * Check if a float is safe to use. ie: Not too big or small.
 * @public
 */
export declare const isSafeFloat: (n: number) => boolean;

/** @public */
export declare function linesIntersect(A: VecLike, B: VecLike, C: VecLike, D: VecLike): boolean;

/** @public @react */
export declare function LoadingScreen({ children }: LoadingScreenProps): JSX_2.Element;

/** @public */
export declare interface LoadingScreenProps {
    children: ReactNode;
}

/**
 * Loads a snapshot of the editor's instance state into the store of a new editor instance.
 *
 * @public
 * @param store - The store to load the instance state into
 * @param snapshot - The instance state snapshot to load
 * @returns
 */
export declare function loadSessionStateSnapshotIntoStore(store: TLStore, snapshot: TLSessionStateSnapshot): void;

/**
 * Loads a snapshot into a store.
 * @public
 */
export declare function loadSnapshot(store: TLStore, _snapshot: Partial<TLEditorSnapshot> | TLStoreSnapshot): void;

/** @public */
export declare function loopToHtmlElement(elm: Element): HTMLElement;

/** @public */
export declare class Mat {
    constructor(a: number, b: number, c: number, d: number, e: number, f: number);
    a: number;
    b: number;
    c: number;
    d: number;
    e: number;
    f: number;
    equals(m: Mat | MatModel): boolean;
    identity(): this;
    multiply(m: Mat | MatModel): this;
    rotate(r: number, cx?: number, cy?: number): Mat;
    translate(x: number, y: number): Mat;
    scale(x: number, y: number): this;
    invert(): this;
    applyToPoint(point: VecLike): Vec;
    applyToPoints(points: VecLike[]): Vec[];
    rotation(): number;
    point(): Vec;
    decomposed(): {
        rotation: number;
        scaleX: number;
        scaleY: number;
        x: number;
        y: number;
    };
    toCssString(): string;
    setTo(model: MatModel): this;
    decompose(): {
        rotation: number;
        scaleX: number;
        scaleY: number;
        x: number;
        y: number;
    };
    clone(): Mat;
    static Identity(): Mat;
    static Translate(x: number, y: number): Mat;
    static Rotate(r: number, cx?: number, cy?: number): Mat;
    static Scale: {
        (x: number, y: number, cx: number, cy: number): MatModel;
        (x: number, y: number): MatModel;
    };
    static Multiply(m1: MatModel, m2: MatModel): MatModel;
    static Inverse(m: MatModel): MatModel;
    static Absolute(m: MatLike): MatModel;
    static Compose(...matrices: MatLike[]): Mat;
    static Point(m: MatLike): Vec;
    static Rotation(m: MatLike): number;
    static Decompose(m: MatLike): {
        rotation: number;
        scaleX: number;
        scaleY: number;
        x: number;
        y: number;
    };
    static Smooth(m: MatLike, precision?: number): MatLike;
    static toCssString(m: MatLike): string;
    static applyToPoint(m: MatLike, point: VecLike): Vec;
    static applyToXY(m: MatLike, x: number, y: number): number[];
    static applyToPoints(m: MatLike, points: VecLike[]): Vec[];
    static applyToBounds(m: MatLike, box: Box): Box;
    static From(m: MatLike): Mat;
    static Cast(m: MatLike): Mat;
}

/** @public */
export declare type MatLike = Mat | MatModel;

/** @public */
export declare interface MatModel {
    a: number;
    b: number;
    c: number;
    d: number;
    e: number;
    f: number;
}

/* Excluded from this release type: normalizeWheel */

/** @public */
export declare function openWindow(url: string, target?: string): void;

/* Excluded from this release type: OptionalErrorBoundary */

/** @public */
export declare type OptionalKeys<T, K extends keyof T> = Omit<T, K> & Partial<Pick<T, K>>;

/**
 * Find the approximate perimeter of an ellipse.
 *
 * @param rx - The ellipse's x radius.
 * @param ry - The ellipse's y radius.
 * @public
 */
export declare function perimeterOfEllipse(rx: number, ry: number): number;

/** @public */
export declare const PI: number;

/** @public */
export declare const PI2: number;

/** @public */
export declare class Point2d extends Geometry2d {
    point: Vec;
    constructor(config: Omit<Geometry2dOptions, 'isClosed' | 'isFilled'> & {
        margin: number;
        point: Vec;
    });
    getVertices(): Vec[];
    nearestPoint(): Vec;
    hitTestLineSegment(A: Vec, B: Vec, margin: number): boolean;
    getSvgPathData(): string;
}

/**
 * Get whether a point is inside of a polygon.
 *
 * ```ts
 * const result = pointInPolygon(myPoint, myPoints)
 * ```
 *
 * @public
 */
export declare function pointInPolygon(A: VecLike, points: VecLike[]): boolean;

/** @public */
export declare interface PointsSnapIndicator {
    id: string;
    type: 'points';
    points: VecLike[];
}

/** @public */
export declare class Polygon2d extends Polyline2d {
    constructor(config: Omit<Geometry2dOptions, 'isClosed'> & {
        points: Vec[];
    });
}

/** @public */
export declare function polygonIntersectsPolyline(polygon: VecLike[], polyline: VecLike[]): boolean;

/** @public */
export declare function polygonsIntersect(a: VecLike[], b: VecLike[]): boolean;

/** @public */
export declare class Polyline2d extends Geometry2d {
    points: Vec[];
    constructor(config: Omit<Geometry2dOptions, 'isClosed' | 'isFilled'> & {
        points: Vec[];
    });
    _segments?: Edge2d[];
    get segments(): Edge2d[];
    getLength(): number;
    getVertices(): Vec[];
    nearestPoint(A: Vec): Vec;
    hitTestLineSegment(A: Vec, B: Vec, distance?: number): boolean;
    getSvgPathData(): string;
}

/** @public */
export declare function precise(A: VecLike): string;

/**
 * This function calls `event.preventDefault()` for you. Why is that useful?
 *
 * Beacuase if you enable `window.preventDefaultLogging = true` it'll log out a message when it
 * happens. Because we use console.warn rather than (log) you'll get a stack trace in the inspector
 * telling you exactly where it happened. This is important because `e.preventDefault()` is the
 * source of many bugs, but unfortuantly it can't be avoided because it also stops a lot of default
 * behaviour which doesn't make sense in our UI
 *
 * @param event - To prevent default on
 * @public
 */
export declare function preventDefault(event: Event | React_2.BaseSyntheticEvent): void;

/**
 * Convert radians to degrees.
 *
 * @param r - The degree in radians.
 * @public
 */
export declare function radiansToDegrees(r: number): number;

/**
 * Finds the intersection of two ranges.
 *
 * @param a0 - The start point in the A range
 * @param a1 - The end point in the A range
 * @param b0 - The start point in the B range
 * @param b1 - The end point in the B range
 * @returns The intersection of the ranges, or null if no intersection
 * @public
 */
export declare function rangeIntersection(a0: number, a1: number, b0: number, b1: number): [number, number] | null;

export { react }

/**
 * A map of {@link @tldraw/tlschema#StyleProp | StyleProps} to their {@link SharedStyle} values. See
 * {@link Editor.getSharedStyles}.
 *
 * @public
 */
export declare class ReadonlySharedStyleMap {
    /* Excluded from this release type: map */
    constructor(entries?: Iterable<[StyleProp<unknown>, SharedStyle<unknown>]>);
    get<T>(prop: StyleProp<T>): SharedStyle<T> | undefined;
    getAsKnownValue<T>(prop: StyleProp<T>): T | undefined;
    get size(): number;
    equals(other: ReadonlySharedStyleMap): boolean;
    keys(): IterableIterator<StyleProp<any>>;
    values(): IterableIterator<SharedStyle<unknown>>;
    entries(): IterableIterator<[StyleProp<any>, SharedStyle<unknown>]>;
    [Symbol.iterator](): IterableIterator<[StyleProp<any>, SharedStyle<unknown>]>;
}

/** @public */
export declare class Rectangle2d extends Polygon2d {
    x: number;
    y: number;
    w: number;
    h: number;
    constructor(config: Omit<Geometry2dOptions, 'isClosed'> & {
        height: number;
        width: number;
        x?: number;
        y?: number;
    });
    getBounds(): Box;
    getSvgPathData(): string;
}

/** @public */
export declare function refreshPage(): void;

/** @public */
export declare function releasePointerCapture(element: Element, event: PointerEvent | React_2.PointerEvent<Element>): void;

/** @public */
export declare type RequiredKeys<T, K extends keyof T> = Required<Pick<T, K>> & Omit<T, K>;

/** @public */
export declare function resizeBox<T extends TLBaseBoxShape>(shape: T, info: {
    handle: TLResizeHandle;
    initialBounds: Box;
    initialShape: T;
    mode: TLResizeMode;
    newPoint: VecModel;
    scaleX: number;
    scaleY: number;
}, opts?: Partial<{
    maxHeight: number;
    maxWidth: number;
    minHeight: number;
    minWidth: number;
}>): T;

/** @public */
export declare type ResizeBoxOptions = Partial<{
    maxHeight: number;
    maxWidth: number;
    minHeight: number;
    minWidth: number;
}>;

/** @public */
export declare const ROTATE_CORNER_TO_SELECTION_CORNER: {
    readonly bottom_left_rotate: "bottom_left";
    readonly bottom_right_rotate: "bottom_right";
    readonly mobile_rotate: "top_left";
    readonly top_left_rotate: "top_left";
    readonly top_right_rotate: "top_right";
};

/** @public */
export declare type RotateCorner = 'bottom_left_rotate' | 'bottom_right_rotate' | 'mobile_rotate' | 'top_left_rotate' | 'top_right_rotate';

/** @public */
export declare function rotateSelectionHandle(handle: SelectionHandle, rotation: number): SelectionHandle;

/** @public */
export declare const runtime: {
    hardReset: () => void;
    openWindow: (url: string, target: string) => void;
    refreshPage: () => void;
};

/** @public */
export declare interface ScribbleItem {
    id: string;
    scribble: TLScribble;
    timeoutMs: number;
    delayRemaining: number;
    prev: null | VecModel;
    next: null | VecModel;
}

/** @public */
export declare class ScribbleManager {
    private editor;
    scribbleItems: Map<string, ScribbleItem>;
    state: "paused" | "running";
    constructor(editor: Editor);
    addScribble: (scribble: Partial<TLScribble>, id?: string) => ScribbleItem;
    reset(): void;
    /**
     * Start stopping the scribble. The scribble won't be removed until its last point is cleared.
     *
     * @public
     */
    stop: (id: ScribbleItem['id']) => ScribbleItem;
    /**
     * Set the scribble's next point.
     *
     * @param point - The point to add.
     * @public
     */
    addPoint: (id: ScribbleItem['id'], x: number, y: number) => ScribbleItem;
    /**
     * Update on each animation frame.
     *
     * @param elapsed - The number of milliseconds since the last tick.
     * @public
     */
    tick: (elapsed: number) => void;
}

/** @public */
export declare type SelectionCorner = 'bottom_left' | 'bottom_right' | 'top_left' | 'top_right';

/** @public */
export declare type SelectionEdge = 'bottom' | 'left' | 'right' | 'top';

/** @public */
export declare type SelectionHandle = SelectionCorner | SelectionEdge;

/** @public */
export declare function setPointerCapture(element: Element, event: PointerEvent | React_2.PointerEvent<Element>): void;

/** @public */
export declare function setRuntimeOverrides(input: Partial<typeof runtime>): void;

/** @public */
export declare function setUserPreferences(user: TLUserPreferences): void;

/** @public */
export declare abstract class ShapeUtil<Shape extends TLUnknownShape = TLUnknownShape> {
    editor: Editor;
    constructor(editor: Editor);
    /**
     * Props allow you to define the shape's properties in a way that the editor can understand.
     * This has two main uses:
     *
     * 1. Validation. Shapes will be validated using these props to stop bad data from being saved.
     * 2. Styles. Each {@link @tldraw/tlschema#StyleProp} in the props can be set on many shapes at
     *    once, and will be remembered from one shape to the next.
     *
     * @example
     * ```tsx
     * import {T, TLBaseShape, TLDefaultColorStyle, DefaultColorStyle, ShapeUtil} from 'tldraw'
     *
     * type MyShape = TLBaseShape<'mine', {
     *      color: TLDefaultColorStyle,
     *      text: string,
     * }>
     *
     * class MyShapeUtil extends ShapeUtil<MyShape> {
     *     static props = {
     *         // we use tldraw's built-in color style:
     *         color: DefaultColorStyle,
     *         // validate that the text prop is a string:
     *         text: T.string,
     *     }
     * }
     * ```
     */
    static props?: RecordProps<TLUnknownShape>;
    /**
     * Migrations allow you to make changes to a shape's props over time. Read the
     * {@link https://staging.tldraw.dev/docs/persistence#Shape-props-migrations | shape prop migrations}
     * guide for more information.
     */
    static migrations?: LegacyMigrations | MigrationSequence | TLPropsMigrations;
    /**
     * The type of the shape util, which should match the shape's type.
     *
     * @public
     */
    static type: string;
    /**
     * Get the default props for a shape.
     *
     * @public
     */
    abstract getDefaultProps(): Shape['props'];
    /**
     * Get the shape's geometry.
     *
     * @param shape - The shape.
     * @public
     */
    abstract getGeometry(shape: Shape): Geometry2d;
    /**
     * Get a JSX element for the shape (as an HTML element).
     *
     * @param shape - The shape.
     * @public
     */
    abstract component(shape: Shape): any;
    /**
     * Get JSX describing the shape's indicator (as an SVG element).
     *
     * @param shape - The shape.
     * @public
     */
    abstract indicator(shape: Shape): any;
    /**
     * Whether the shape can be snapped to by another shape.
     *
     * @public
     */
    canSnap: TLShapeUtilFlag<Shape>;
    /**
     * Whether the shape can be scrolled while editing.
     *
     * @public
     */
    canScroll: TLShapeUtilFlag<Shape>;
    /**
     * Whether the shape can be bound to. See {@link TLShapeUtilCanBindOpts} for details.
     *
     * @public
     */
    canBind(opts: TLShapeUtilCanBindOpts<Shape>): boolean;
    /**
     * Whether the shape can be double clicked to edit.
     *
     * @public
     */
    canEdit: TLShapeUtilFlag<Shape>;
    /**
     * Whether the shape can be resized.
     *
     * @public
     */
    canResize: TLShapeUtilFlag<Shape>;
    /**
     * Whether the shape can be edited in read-only mode.
     *
     * @public
     */
    canEditInReadOnly: TLShapeUtilFlag<Shape>;
    /**
     * Whether the shape can be cropped.
     *
     * @public
     */
    canCrop: TLShapeUtilFlag<Shape>;
    /**
     * Whether the shape participates in stacking, aligning, and distributing.
     *
     * @public
     */
    canBeLaidOut: TLShapeUtilFlag<Shape>;
    /* Excluded from this release type: providesBackgroundForChildren */
    /**
     * Whether the shape should hide its resize handles when selected.
     *
     * @public
     */
    hideResizeHandles: TLShapeUtilFlag<Shape>;
    /**
     * Whether the shape should hide its rotation handles when selected.
     *
     * @public
     */
    hideRotateHandle: TLShapeUtilFlag<Shape>;
    /**
     * Whether the shape should hide its selection bounds background when selected.
     *
     * @public
     */
    hideSelectionBoundsBg: TLShapeUtilFlag<Shape>;
    /**
     * Whether the shape should hide its selection bounds foreground when selected.
     *
     * @public
     */
    hideSelectionBoundsFg: TLShapeUtilFlag<Shape>;
    /**
     * Whether the shape's aspect ratio is locked.
     *
     * @public
     */
    isAspectRatioLocked: TLShapeUtilFlag<Shape>;
    /* Excluded from this release type: backgroundComponent */
    /**
     * Get the interpolated props for an animating shape. This is an optional method.
     *
     * @example
     *
     * ```ts
     * util.getInterpolatedProps?.(startShape, endShape, t)
     * ```
     *
     * @param startShape - The initial shape.
     * @param endShape - The initial shape.
     * @param progress - The normalized progress between zero (start) and 1 (end).
     * @public
     */
    getInterpolatedProps?(startShape: Shape, endShape: Shape, progress: number): Shape['props'];
    /**
     * Get an array of handle models for the shape. This is an optional method.
     *
     * @example
     *
     * ```ts
     * util.getHandles?.(myShape)
     * ```
     *
     * @param shape - The shape.
     * @public
     */
    getHandles?(shape: Shape): TLHandle[];
    /**
     * Get whether the shape can receive children of a given type.
     *
     * @param type - The shape type.
     * @public
     */
    canReceiveNewChildrenOfType(shape: Shape, type: TLShape['type']): boolean;
    /**
     * Get whether the shape can receive children of a given type.
     *
     * @param shape - The shape type.
     * @param shapes - The shapes that are being dropped.
     * @public
     */
    canDropShapes(shape: Shape, shapes: TLShape[]): boolean;
    /**
     * Get the shape as an SVG object.
     *
     * @param shape - The shape.
     * @param ctx - The export context for the SVG - used for adding e.g. \<def\>s
     * @returns An SVG element.
     * @public
     */
    toSvg?(shape: Shape, ctx: SvgExportContext): null | Promise<null | ReactElement> | ReactElement;
    /**
     * Get the shape's background layer as an SVG object.
     *
     * @param shape - The shape.
     * @param ctx - ctx - The export context for the SVG - used for adding e.g. \<def\>s
     * @returns An SVG element.
     * @public
     */
    toBackgroundSvg?(shape: Shape, ctx: SvgExportContext): null | Promise<null | ReactElement> | ReactElement;
    /* Excluded from this release type: expandSelectionOutlinePx */
    /**
     * Return elements to be added to the \<defs\> section of the canvases SVG context. This can be
     * used to define SVG content (e.g. patterns & masks) that can be referred to by ID from svg
     * elements returned by `component`.
     *
     * Each def should have a unique `key`. If multiple defs from different shapes all have the same
     * key, only one will be used.
     */
    getCanvasSvgDefs(): TLShapeUtilCanvasSvgDef[];
    /**
     * Get the geometry to use when snapping to this this shape in translate/resize operations. See
     * {@link BoundsSnapGeometry} for details.
     */
    getBoundsSnapGeometry(shape: Shape): BoundsSnapGeometry;
    /**
     * Get the geometry to use when snapping handles to this shape. See {@link HandleSnapGeometry}
     * for details.
     */
    getHandleSnapGeometry(shape: Shape): HandleSnapGeometry;
    /**
     * A callback called just before a shape is created. This method provides a last chance to modify
     * the created shape.
     *
     * @example
     *
     * ```ts
     * onBeforeCreate = (next) => {
     * 	return { ...next, x: next.x + 1 }
     * }
     * ```
     *
     * @param next - The next shape.
     * @returns The next shape or void.
     * @public
     */
    onBeforeCreate?: TLOnBeforeCreateHandler<Shape>;
    /**
     * A callback called just before a shape is updated. This method provides a last chance to modify
     * the updated shape.
     *
     * @example
     *
     * ```ts
     * onBeforeUpdate = (prev, next) => {
     * 	if (prev.x === next.x) {
     * 		return { ...next, x: next.x + 1 }
     * 	}
     * }
     * ```
     *
     * @param prev - The previous shape.
     * @param next - The next shape.
     * @returns The next shape or void.
     * @public
     */
    onBeforeUpdate?: TLOnBeforeUpdateHandler<Shape>;
    /**
     * A callback called when some other shapes are dragged over this one.
     *
     * @example
     *
     * ```ts
     * onDragShapesOver = (shape, shapes) => {
     * 	this.editor.reparentShapes(shapes, shape.id)
     * }
     * ```
     *
     * @param shape - The shape.
     * @param shapes - The shapes that are being dragged over this one.
     * @public
     */
    onDragShapesOver?: TLOnDragHandler<Shape>;
    /**
     * A callback called when some other shapes are dragged out of this one.
     *
     * @param shape - The shape.
     * @param shapes - The shapes that are being dragged out.
     * @public
     */
    onDragShapesOut?: TLOnDragHandler<Shape>;
    /**
     * A callback called when some other shapes are dropped over this one.
     *
     * @param shape - The shape.
     * @param shapes - The shapes that are being dropped over this one.
     * @public
     */
    onDropShapesOver?: TLOnDragHandler<Shape>;
    /**
     * A callback called when a shape starts being resized.
     *
     * @param shape - The shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onResizeStart?: TLOnResizeStartHandler<Shape>;
    /**
     * A callback called when a shape changes from a resize.
     *
     * @param shape - The shape at the start of the resize.
     * @param info - Info about the resize.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onResize?: TLOnResizeHandler<Shape>;
    /**
     * A callback called when a shape finishes resizing.
     *
     * @param initial - The shape at the start of the resize.
     * @param current - The current shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onResizeEnd?: TLOnResizeEndHandler<Shape>;
    /**
     * A callback called when a shape starts being translated.
     *
     * @param shape - The shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onTranslateStart?: TLOnTranslateStartHandler<Shape>;
    /**
     * A callback called when a shape changes from a translation.
     *
     * @param initial - The shape at the start of the translation.
     * @param current - The current shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onTranslate?: TLOnTranslateHandler<Shape>;
    /**
     * A callback called when a shape finishes translating.
     *
     * @param initial - The shape at the start of the translation.
     * @param current - The current shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onTranslateEnd?: TLOnTranslateEndHandler<Shape>;
    /**
     * A callback called when a shape's handle changes.
     *
     * @param shape - The current shape.
     * @param info - An object containing the handle and whether the handle is 'precise' or not.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onHandleDrag?: TLOnHandleDragHandler<Shape>;
    /**
     * A callback called when a shape starts being rotated.
     *
     * @param shape - The shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onRotateStart?: TLOnRotateStartHandler<Shape>;
    /**
     * A callback called when a shape changes from a rotation.
     *
     * @param initial - The shape at the start of the rotation.
     * @param current - The current shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onRotate?: TLOnRotateHandler<Shape>;
    /**
     * A callback called when a shape finishes rotating.
     *
     * @param initial - The shape at the start of the rotation.
     * @param current - The current shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onRotateEnd?: TLOnRotateEndHandler<Shape>;
    /* Excluded from this release type: onBindingChange */
    /**
     * A callback called when a shape's children change.
     *
     * @param shape - The shape.
     * @returns An array of shape updates, or void.
     * @public
     */
    onChildrenChange?: TLOnChildrenChangeHandler<Shape>;
    /**
     * A callback called when a shape's handle is double clicked.
     *
     * @param shape - The shape.
     * @param handle - The handle that is double-clicked.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onDoubleClickHandle?: TLOnDoubleClickHandleHandler<Shape>;
    /**
     * A callback called when a shape's edge is double clicked.
     *
     * @param shape - The shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onDoubleClickEdge?: TLOnDoubleClickHandler<Shape>;
    /**
     * A callback called when a shape is double clicked.
     *
     * @param shape - The shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onDoubleClick?: TLOnDoubleClickHandler<Shape>;
    /**
     * A callback called when a shape is clicked.
     *
     * @param shape - The shape.
     * @returns A change to apply to the shape, or void.
     * @public
     */
    onClick?: TLOnClickHandler<Shape>;
    /**
     * A callback called when a shape finishes being editing.
     *
     * @param shape - The shape.
     * @public
     */
    onEditEnd?: TLOnEditEndHandler<Shape>;
}

/**
 * The value of a particular {@link @tldraw/tlschema#StyleProp}.
 *
 * A `mixed` style means that in the current selection, there are lots of different values for the
 * same style prop - e.g. a red and a blue shape are selected.
 *
 * A `shared` style means that all shapes in the selection share the same value for this style prop.
 *
 * @public
 */
export declare type SharedStyle<T> = {
    readonly type: 'mixed';
} | {
    readonly type: 'shared';
    readonly value: T;
};

/* Excluded from this release type: SharedStyleMap */

/**
 * Get the short angle distance between two angles.
 *
 * @param a0 - The first angle.
 * @param a1 - The second angle.
 * @public
 */
export declare function shortAngleDist(a0: number, a1: number): number;

/** @public */
export declare const SIDES: readonly ["top", "right", "bottom", "left"];

export { Signal }

/** @public */
export declare const SIN: (x: number) => number;

/**
 * Clamp rotation to even segments.
 *
 * @param r - The rotation in radians.
 * @param segments - The number of segments.
 * @public
 */
export declare function snapAngle(r: number, segments: number): number;

/** @public */
export declare interface SnapData {
    nudge: Vec;
}

/** @public */
export declare type SnapIndicator = GapsSnapIndicator | PointsSnapIndicator;

/** @public */
export declare class SnapManager {
    readonly editor: Editor;
    readonly shapeBounds: BoundsSnaps;
    readonly handles: HandleSnaps;
    private _snapIndicators;
    constructor(editor: Editor);
    getIndicators(): SnapIndicator[];
    clearIndicators(): void;
    setIndicators(indicators: SnapIndicator[]): void;
    getSnapThreshold(): number;
    getSnappableShapes(): Set<TLShapeId>;
    getCurrentCommonAncestor(): TLShapeId | undefined;
}

/** @public */
export declare class Stadium2d extends Geometry2d {
    config: Omit<Geometry2dOptions, 'isClosed'> & {
        height: number;
        width: number;
    };
    w: number;
    h: number;
    a: Arc2d;
    b: Edge2d;
    c: Arc2d;
    d: Edge2d;
    constructor(config: Omit<Geometry2dOptions, 'isClosed'> & {
        height: number;
        width: number;
    });
    nearestPoint(A: Vec): Vec;
    hitTestLineSegment(A: Vec, B: Vec): boolean;
    getVertices(): Vec[];
    getBounds(): Box;
    getLength(): number;
    getSvgPathData(): string;
}

/** @public */
export declare abstract class StateNode implements Partial<TLEventHandlers> {
    editor: Editor;
    performanceTracker: PerformanceTracker;
    constructor(editor: Editor, parent?: StateNode);
    static id: string;
    static initial?: string;
    static children?: () => TLStateNodeConstructor[];
    static isLockable: boolean;
    id: string;
    type: 'branch' | 'leaf' | 'root';
    shapeType?: string;
    initial?: string;
    children?: Record<string, StateNode>;
    isLockable: boolean;
    parent: StateNode;
    /**
     * This node's path of active state nodes
     *
     * @public
     */
    getPath(): string;
    _path: Computed<string>;
    /**
     * This node's current active child node, if any.
     *
     * @public
     */
    getCurrent(): StateNode | undefined;
    private _current;
    /**
     * Whether this node is active.
     *
     * @public
     */
    getIsActive(): boolean;
    private _isActive;
    /**
     * Transition to a new active child state node.
     *
     * @example
     * ```ts
     * parentState.transition('childStateA')
     * parentState.transition('childStateB', { myData: 4 })
     *```
     *
     * @param id - The id of the child state node to transition to.
     * @param info - Any data to pass to the `onEnter` and `onExit` handlers.
     *
     * @public
     */
    transition: (id: string, info?: any) => this;
    handleEvent: (info: Exclude<TLEventInfo, TLPinchEventInfo>) => void;
    enter: (info: any, from: string) => void;
    exit: (info: any, from: string) => void;
    /**
     * This is a hack / escape hatch that will tell the editor to
     * report a different state as active (in `getCurrentToolId()`) when
     * this state is active. This is usually used when a tool transitions
     * to a child of a different state for a certain interaction and then
     * returns to the original tool when that interaction completes; and
     * where we would want to show the original tool as active in the UI.
     *
     * @public
     */
    _currentToolIdMask: Atom<string | undefined, unknown>;
    getCurrentToolIdMask(): string | undefined;
    setCurrentToolIdMask(id: string | undefined): void;
    onWheel?: TLEventHandlers['onWheel'];
    onPointerDown?: TLEventHandlers['onPointerDown'];
    onPointerMove?: TLEventHandlers['onPointerMove'];
    onLongPress?: TLEventHandlers['onLongPress'];
    onPointerUp?: TLEventHandlers['onPointerUp'];
    onDoubleClick?: TLEventHandlers['onDoubleClick'];
    onTripleClick?: TLEventHandlers['onTripleClick'];
    onQuadrupleClick?: TLEventHandlers['onQuadrupleClick'];
    onRightClick?: TLEventHandlers['onRightClick'];
    onMiddleClick?: TLEventHandlers['onMiddleClick'];
    onKeyDown?: TLEventHandlers['onKeyDown'];
    onKeyUp?: TLEventHandlers['onKeyUp'];
    onKeyRepeat?: TLEventHandlers['onKeyRepeat'];
    onCancel?: TLEventHandlers['onCancel'];
    onComplete?: TLEventHandlers['onComplete'];
    onInterrupt?: TLEventHandlers['onInterrupt'];
    onTick?: TLEventHandlers['onTick'];
    onEnter?: TLEnterEventHandler;
    onExit?: TLExitEventHandler;
}

/** @public */
export declare const stopEventPropagation: (e: any) => any;

/** @public @react */
export declare function SVGContainer({ children, className, ...rest }: SVGContainerProps): JSX_2.Element;

/** @public */
export declare type SVGContainerProps = React_3.HTMLAttributes<SVGElement>;

/** @public */
export declare interface SvgExportContext {
    /**
     * Add contents to the `<defs>` section of the export SVG. Each export def should have a unique
     * key. If multiple defs come with the same key, only one will be added.
     */
    addExportDef(def: SvgExportDef): void;
    /**
     * Whether the export should be in dark mode.
     */
    readonly isDarkMode: boolean;
}

/** @public */
export declare interface SvgExportDef {
    key: string;
    getElement: () => null | Promise<null | ReactElement> | ReactElement;
}

/**
 * A string that is unique per browser tab
 * @public
 */
export declare const TAB_ID: string;

/** @public */
export declare class TextManager {
    editor: Editor;
    baseElm: HTMLDivElement;
    constructor(editor: Editor);
    measureText: (textToMeasure: string, opts: {
        /**
         * When maxWidth is a number, the text will be wrapped to that maxWidth. When maxWidth
         * is null, the text will be measured without wrapping, but explicit line breaks and
         * space are preserved.
         */
        maxWidth: null | number;
        disableOverflowWrapBreaking?: boolean;
        fontFamily: string;
        fontSize: number;
        fontStyle: string;
        fontWeight: string;
        lineHeight: number;
        minWidth?: null | number;
        padding: string;
    }) => BoxModel & {
        scrollWidth: number;
    };
    /**
     * Given an html element, measure the position of each span of unbroken
     * word/white-space characters within any text nodes it contains.
     */
    measureElementTextNodeSpans(element: HTMLElement, { shouldTruncateToFirstLine }?: {
        shouldTruncateToFirstLine?: boolean;
    }): {
        didTruncate: boolean;
        spans: {
            box: BoxModel;
            text: string;
        }[];
    };
    /**
     * Measure text into individual spans. Spans are created by rendering the
     * text, then dividing it up according to line breaks and word boundaries.
     *
     * It works by having the browser render the text, then measuring the
     * position of each character. You can use this to replicate the text-layout
     * algorithm of the current browser in e.g. an SVG export.
     */
    measureTextSpans(textToMeasure: string, opts: TLMeasureTextSpanOpts): {
        box: BoxModel;
        text: string;
    }[];
}

/** @public */
export declare type TLAnyBindingUtilConstructor = TLBindingUtilConstructor<any>;

/** @public */
export declare type TLAnyShapeUtilConstructor = TLShapeUtilConstructor<any>;

/** @public */
export declare type TLBaseBoxShape = TLBaseShape<string, {
    h: number;
    w: number;
}>;

/** @public */
export declare interface TLBaseEventInfo {
    type: UiEventType;
    shiftKey: boolean;
    altKey: boolean;
    ctrlKey: boolean;
}

/** @public */
export declare interface TLBindingUtilConstructor<T extends TLUnknownBinding, U extends BindingUtil<T> = BindingUtil<T>> {
    new (editor: Editor): U;
    type: T['type'];
    /** Validations for this binding's props. */
    props?: RecordProps<T>;
    /** Migrations for this binding's props. */
    migrations?: TLPropsMigrations;
}

/** @public */
export declare interface TLBrushProps {
    brush: BoxModel;
    color?: string;
    opacity?: number;
    className?: string;
}

/** @public */
export declare interface TLCameraConstraints {
    /** The bounds (in page space) of the constrained space */
    bounds: BoxModel;
    /** The padding inside of the viewport (in screen space) */
    padding: VecLike;
    /** The origin for placement. Used to position the bounds within the viewport when an axis is fixed or contained and zoom is below the axis fit. */
    origin: VecLike;
    /** The camera's initial zoom, used also when the camera is reset.
     *
     * - `default`: Sets the initial zoom to 100%.
     * - `fit-x`: The x axis will completely fill the viewport bounds.
     * - `fit-y`: The y axis will completely fill the viewport bounds.
     * - `fit-min`: The smaller axis will completely fill the viewport bounds.
     * - `fit-max`: The larger axis will completely fill the viewport bounds.
     * - `fit-x-100`: The x axis will completely fill the viewport bounds, or 100% zoom, whichever is smaller.
     * - `fit-y-100`: The y axis will completely fill the viewport bounds, or 100% zoom, whichever is smaller.
     * - `fit-min-100`: The smaller axis will completely fill the viewport bounds, or 100% zoom, whichever is smaller.
     * - `fit-max-100`: The larger axis will completely fill the viewport bounds, or 100% zoom, whichever is smaller.
     */
    initialZoom: 'default' | 'fit-max-100' | 'fit-max' | 'fit-min-100' | 'fit-min' | 'fit-x-100' | 'fit-x' | 'fit-y-100' | 'fit-y';
    /** The camera's base for its zoom steps.
     *
     * - `default`: Sets the initial zoom to 100%.
     * - `fit-x`: The x axis will completely fill the viewport bounds.
     * - `fit-y`: The y axis will completely fill the viewport bounds.
     * - `fit-min`: The smaller axis will completely fill the viewport bounds.
     * - `fit-max`: The larger axis will completely fill the viewport bounds.
     * - `fit-x-100`: The x axis will completely fill the viewport bounds, or 100% zoom, whichever is smaller.
     * - `fit-y-100`: The y axis will completely fill the viewport bounds, or 100% zoom, whichever is smaller.
     * - `fit-min-100`: The smaller axis will completely fill the viewport bounds, or 100% zoom, whichever is smaller.
     * - `fit-max-100`: The larger axis will completely fill the viewport bounds, or 100% zoom, whichever is smaller.
     */
    baseZoom: 'default' | 'fit-max-100' | 'fit-max' | 'fit-min-100' | 'fit-min' | 'fit-x-100' | 'fit-x' | 'fit-y-100' | 'fit-y';
    /** The behavior for the constraints for both axes or each axis individually.
     *
     * - `free`: The bounds are ignored when moving the camera.
     * - 'fixed': The bounds will be positioned within the viewport based on the origin
     * - `contain`: The 'fixed' behavior will be used when the zoom is below the zoom level at which the bounds would fill the viewport; and when above this zoom, the bounds will use the 'inside' behavior.
     * - `inside`: The bounds will stay completely within the viewport.
     * - `outside`: The bounds will stay touching the viewport.
     */
    behavior: 'contain' | 'fixed' | 'free' | 'inside' | 'outside' | {
        x: 'contain' | 'fixed' | 'free' | 'inside' | 'outside';
        y: 'contain' | 'fixed' | 'free' | 'inside' | 'outside';
    };
}

/** @public */
export declare type TLCameraMoveOptions = Partial<{
    /** An (optional) animation to use. */
    animation: Partial<{
        /** An easing function to apply to the animation's progress from start to end. */
        easing: (t: number) => number;
        /** The time the animation should take to arrive at the specified camera coordinates. */
        duration: number;
    }>;
    /** Whether to force the camera to move, even if the user's camera options have locked the camera. */
    force: boolean;
    /** Whether to move the camera immediately, rather than on the next tick. */
    immediate: boolean;
    /** Whether to reset the camera to its default position and zoom. */
    reset: boolean;
}>;

/** @public */
export declare interface TLCameraOptions {
    /** Whether the camera is locked. */
    isLocked: boolean;
    /** The speed of a scroll wheel / trackpad pan. Default is 1. */
    panSpeed: number;
    /** The speed of a scroll wheel / trackpad zoom. Default is 1. */
    zoomSpeed: number;
    /** The steps that a user can zoom between with zoom in / zoom out. The first and last value will determine the min and max zoom. */
    zoomSteps: number[];
    /** Controls whether the wheel pans or zooms.
     *
     * - `zoom`: The wheel will zoom in and out.
     * - `pan`: The wheel will pan the camera.
     * - `none`: The wheel will do nothing.
     */
    wheelBehavior: 'none' | 'pan' | 'zoom';
    /** The camera constraints. */
    constraints?: TLCameraConstraints;
}

/** @public */
export declare type TLCancelEvent = (info: TLCancelEventInfo) => void;

/** @public */
export declare interface TLCancelEventInfo {
    type: 'misc';
    name: 'cancel';
}

/** @public */
export declare interface TLCanvasComponentProps {
    className?: string;
}

/** @public */
export declare type TLClickEvent = (info: TLClickEventInfo) => void;

/** @public */
export declare type TLClickEventInfo = TLBaseEventInfo & {
    button: number;
    name: TLCLickEventName;
    phase: 'down' | 'settle' | 'up';
    point: VecLike;
    pointerId: number;
    type: 'click';
} & TLPointerEventTarget;

/** @public */
export declare type TLCLickEventName = 'double_click' | 'quadruple_click' | 'triple_click';

/** @public */
export declare type TLClickState = 'idle' | 'overflow' | 'pendingDouble' | 'pendingOverflow' | 'pendingQuadruple' | 'pendingTriple';

/** @public */
export declare interface TLCollaboratorHintProps {
    className?: string;
    point: VecModel;
    viewport: Box;
    zoom: number;
    opacity?: number;
    color: string;
}

/** @public */
export declare type TLCompleteEvent = (info: TLCompleteEventInfo) => void;

/** @public */
export declare interface TLCompleteEventInfo {
    type: 'misc';
    name: 'complete';
}

/** @public */
export declare interface TLContent {
    shapes: TLShape[];
    bindings: TLBinding[] | undefined;
    rootShapeIds: TLShapeId[];
    assets: TLAsset[];
    schema: SerializedSchema;
}

/** @public */
export declare interface TLCursorProps {
    className?: string;
    point: null | VecModel;
    zoom: number;
    color?: string;
    name: null | string;
    chatMessage: string;
}

/** @public @react */
export declare const TldrawEditor: React_2.NamedExoticComponent<TldrawEditorProps>;

/**
 * Base props for the {@link tldraw#Tldraw} and {@link TldrawEditor} components.
 *
 * @public
 */
export declare interface TldrawEditorBaseProps {
    /**
     * The component's children.
     */
    children?: ReactNode;
    /**
     * An array of shape utils to use in the editor.
     */
    shapeUtils?: readonly TLAnyShapeUtilConstructor[];
    /**
     * An array of binding utils to use in the editor.
     */
    bindingUtils?: readonly TLAnyBindingUtilConstructor[];
    /**
     * An array of tools to add to the editor's state chart.
     */
    tools?: readonly TLStateNodeConstructor[];
    /**
     * Whether to automatically focus the editor when it mounts.
     */
    autoFocus?: boolean;
    /**
     * Overrides for the editor's components, such as handles, collaborator cursors, etc.
     */
    components?: TLEditorComponents;
    /**
     * Called when the editor has mounted.
     */
    onMount?: TLOnMountHandler;
    /**
     * The editor's initial state (usually the id of the first active tool).
     */
    initialState?: string;
    /**
     * A classname to pass to the editor's container.
     */
    className?: string;
    /**
     * The user interacting with the editor.
     */
    user?: TLUser;
    /**
     * Whether to infer dark mode from the user's OS. Defaults to false.
     */
    inferDarkMode?: boolean;
    /**
     * Camera options for the editor.
     */
    cameraOptions?: Partial<TLCameraOptions>;
    /**
     * Options for the editor.
     */
    options?: Partial<TldrawOptions>;
    /**
     * The license key.
     */
    licenseKey?: string;
}

/**
 * Props for the {@link tldraw#Tldraw} and {@link TldrawEditor} components.
 *
 * @public
 **/
export declare type TldrawEditorProps = TldrawEditorBaseProps & TldrawEditorStoreProps;

/** @public */
export declare type TldrawEditorStoreProps = TldrawEditorWithoutStoreProps | TldrawEditorWithStoreProps;

/**
 * Props for the {@link tldraw#Tldraw} and {@link TldrawEditor} components, when not passing in a
 * {@link store#TLStore} directly. If you would like to pass in a store directly, use
 * {@link TldrawEditorWithStoreProps}.
 *
 * @public
 */
export declare interface TldrawEditorWithoutStoreProps extends TLStoreBaseOptions {
    store?: undefined;
    /**
     * Additional migrations to use in the store
     */
    migrations?: readonly MigrationSequence[];
    /**
     * A starting snapshot of data to pre-populate the store. Do not supply both this and
     * `initialData`.
     */
    snapshot?: TLEditorSnapshot | TLStoreSnapshot;
    /**
     * If you would like to persist the store to the browser's local IndexedDB storage and sync it
     * across tabs, provide a key here. Each key represents a single tldraw document.
     */
    persistenceKey?: string;
    sessionId?: string;
}

/**
 * Props for the {@link tldraw#Tldraw} and {@link TldrawEditor} components, when passing in a
 * {@link store#TLStore} directly. If you would like tldraw to create a store for you, use
 * {@link TldrawEditorWithoutStoreProps}.
 *
 * @public
 */
export declare interface TldrawEditorWithStoreProps {
    /**
     * The store to use in the editor.
     */
    store: TLStore | TLStoreWithStatus;
}

/**
 * Options for configuring tldraw. For defaults, see {@link defaultTldrawOptions}.
 *
 * @example
 * ```tsx
 * const options: Partial<TldrawOptions> = {
 *     maxPages: 3,
 *     maxShapesPerPage: 1000,
 * }
 *
 * function MyTldrawComponent() {
 *     return <Tldraw options={options} />
 * }
 * ```
 *
 * @public
 */
export declare interface TldrawOptions {
    readonly maxShapesPerPage: number;
    readonly maxPages: number;
    readonly animationMediumMs: number;
    readonly followChaseViewportSnap: number;
    readonly doubleClickDurationMs: number;
    readonly multiClickDurationMs: number;
    readonly coarseDragDistanceSquared: number;
    readonly dragDistanceSquared: number;
    readonly defaultSvgPadding: number;
    readonly cameraSlideFriction: number;
    readonly maxPointsPerDrawShape: number;
    readonly gridSteps: readonly {
        readonly mid: number;
        readonly min: number;
        readonly step: number;
    }[];
    readonly collaboratorInactiveTimeoutMs: number;
    readonly collaboratorIdleTimeoutMs: number;
    readonly collaboratorCheckIntervalMs: number;
    readonly cameraMovingTimeoutMs: number;
    readonly hitTestMargin: number;
    readonly edgeScrollDelay: number;
    readonly edgeScrollEaseDuration: number;
    readonly edgeScrollSpeed: number;
    readonly edgeScrollDistance: number;
    readonly coarsePointerWidth: number;
    readonly coarseHandleRadius: number;
    readonly handleRadius: number;
    readonly longPressDurationMs: number;
    readonly textShadowLod: number;
    readonly adjacentShapeMargin: number;
    readonly flattenImageBoundsExpand: number;
    readonly flattenImageBoundsPadding: number;
}

/** @public */
export declare interface TLEditorComponents {
    Background?: ComponentType | null;
    SvgDefs?: ComponentType | null;
    Brush?: ComponentType<TLBrushProps> | null;
    ZoomBrush?: ComponentType<TLBrushProps> | null;
    ShapeIndicators?: ComponentType | null;
    ShapeIndicator?: ComponentType<TLShapeIndicatorProps> | null;
    Cursor?: ComponentType<TLCursorProps> | null;
    Canvas?: ComponentType<TLCanvasComponentProps> | null;
    CollaboratorBrush?: ComponentType<TLBrushProps> | null;
    CollaboratorCursor?: ComponentType<TLCursorProps> | null;
    CollaboratorHint?: ComponentType<TLCollaboratorHintProps> | null;
    CollaboratorShapeIndicator?: ComponentType<TLShapeIndicatorProps> | null;
    Grid?: ComponentType<TLGridProps> | null;
    Scribble?: ComponentType<TLScribbleProps> | null;
    CollaboratorScribble?: ComponentType<TLScribbleProps> | null;
    SnapIndicator?: ComponentType<TLSnapIndicatorProps> | null;
    Handles?: ComponentType<TLHandlesProps> | null;
    Handle?: ComponentType<TLHandleProps> | null;
    Spinner?: ComponentType | null;
    SelectionForeground?: ComponentType<TLSelectionForegroundProps> | null;
    SelectionBackground?: ComponentType<TLSelectionBackgroundProps> | null;
    OnTheCanvas?: ComponentType | null;
    InFrontOfTheCanvas?: ComponentType | null;
    LoadingScreen?: ComponentType | null;
    ErrorFallback?: TLErrorFallbackComponent;
    ShapeErrorFallback?: TLShapeErrorFallbackComponent;
    ShapeIndicatorErrorFallback?: TLShapeIndicatorErrorFallbackComponent;
}

/** @public */
export declare interface TLEditorOptions {
    /**
     * The Store instance to use for keeping the app's data. This may be prepopulated, e.g. by loading
     * from a server or database.
     */
    store: TLStore;
    /**
     * An array of shapes to use in the editor. These will be used to create and manage shapes in the editor.
     */
    shapeUtils: readonly TLAnyShapeUtilConstructor[];
    /**
     * An array of bindings to use in the editor. These will be used to create and manage bindings in the editor.
     */
    bindingUtils: readonly TLAnyBindingUtilConstructor[];
    /**
     * An array of tools to use in the editor. These will be used to handle events and manage user interactions in the editor.
     */
    tools: readonly TLStateNodeConstructor[];
    /**
     * Should return a containing html element which has all the styles applied to the editor. If not
     * given, the body element will be used.
     */
    getContainer: () => HTMLElement;
    /**
     * A user defined externally to replace the default user.
     */
    user?: TLUser;
    /**
     * The editor's initial active tool (or other state node id).
     */
    initialState?: string;
    /**
     * Whether to automatically focus the editor when it mounts.
     */
    autoFocus?: boolean;
    /**
     * Whether to infer dark mode from the user's system preferences. Defaults to false.
     */
    inferDarkMode?: boolean;
    /**
     * Options for the editor's camera.
     */
    cameraOptions?: Partial<TLCameraOptions>;
    options?: Partial<TldrawOptions>;
    licenseKey?: string;
}

/**
 * Options for {@link Editor.(run:1)}.
 * @public
 */
export declare interface TLEditorRunOptions extends TLHistoryBatchOptions {
    ignoreShapeLock?: boolean;
}

/** @public */
export declare interface TLEditorSnapshot {
    document: TLStoreSnapshot;
    session: TLSessionStateSnapshot;
}

/** @public */
export declare type TLEnterEventHandler = (info: any, from: string) => void;

/** @public */
export declare interface TLErrorBoundaryProps {
    children: React_3.ReactNode;
    onError?: ((error: unknown) => void) | null;
    fallback: TLErrorFallbackComponent;
}

/** @public */
export declare type TLErrorFallbackComponent = ComponentType<{
    editor?: Editor;
    error: unknown;
}>;

/** @public */
export declare interface TLEventHandlers {
    onPointerDown: TLPointerEvent;
    onPointerMove: TLPointerEvent;
    onLongPress: TLPointerEvent;
    onRightClick: TLPointerEvent;
    onDoubleClick: TLClickEvent;
    onTripleClick: TLClickEvent;
    onQuadrupleClick: TLClickEvent;
    onMiddleClick: TLPointerEvent;
    onPointerUp: TLPointerEvent;
    onKeyDown: TLKeyboardEvent;
    onKeyUp: TLKeyboardEvent;
    onKeyRepeat: TLKeyboardEvent;
    onWheel: TLWheelEvent;
    onCancel: TLCancelEvent;
    onComplete: TLCompleteEvent;
    onInterrupt: TLInterruptEvent;
    onTick: TLTickEvent;
}

/** @public */
export declare type TLEventInfo = TLCancelEventInfo | TLClickEventInfo | TLCompleteEventInfo | TLInterruptEventInfo | TLKeyboardEventInfo | TLPinchEventInfo | TLPointerEventInfo | TLTickEventInfo | TLWheelEventInfo;

/** @public */
export declare interface TLEventMap {
    mount: [];
    'max-shapes': [{
        count: number;
        name: string;
        pageId: TLPageId;
    }];
    change: [HistoryEntry<TLRecord>];
    update: [];
    crash: [{
        error: unknown;
    }];
    'stop-camera-animation': [];
    'stop-following': [];
    event: [TLEventInfo];
    tick: [number];
    frame: [number];
    'select-all-text': [{
        shapeId: TLShapeId;
    }];
}

/** @public */
export declare type TLEventMapHandler<T extends keyof TLEventMap> = (...args: TLEventMap[T]) => void;

/** @public */
export declare type TLEventName = 'cancel' | 'complete' | 'interrupt' | 'tick' | 'wheel' | TLCLickEventName | TLKeyboardEventName | TLPinchEventName | TLPointerEventName;

/** @public */
export declare type TLExitEventHandler = (info: any, to: string) => void;

/** @public */
export declare type TLExternalAssetContent = {
    file: File;
    type: 'file';
} | {
    type: 'url';
    url: string;
};

/** @public */
export declare type TLExternalContent = {
    point?: VecLike;
    sources?: TLExternalContentSource[];
} & ({
    embed: EmbedDefinition;
    type: 'embed';
    url: string;
} | {
    files: File[];
    ignoreParent: boolean;
    type: 'files';
} | {
    text: string;
    type: 'svg-text';
} | {
    text: string;
    type: 'text';
} | {
    type: 'url';
    url: string;
});

/** @public */
export declare type TLExternalContentSource = {
    data: any;
    type: 'excalidraw';
} | {
    data: null | string;
    reason: string;
    type: 'error';
} | {
    data: string;
    subtype: 'html' | 'json' | 'text' | 'url';
    type: 'text';
} | {
    data: TLContent;
    type: 'tldraw';
};

/** @public */
export declare interface TLGridProps {
    x: number;
    y: number;
    z: number;
    size: number;
}

/** @public */
export declare interface TLHandleProps {
    shapeId: TLShapeId;
    handle: TLHandle;
    zoom: number;
    isCoarse: boolean;
    className?: string;
}

/** @public */
export declare interface TLHandlesProps {
    children: ReactNode;
}

/** @public */
export declare interface TLHistoryBatchOptions {
    /**
     * How should this change interact with the history stack?
     * - record: Add to the undo stack and clear the redo stack
     * - record-preserveRedoStack: Add to the undo stack but do not clear the redo stack
     * - ignore: Do not add to the undo stack or the redo stack
     */
    history?: 'ignore' | 'record-preserveRedoStack' | 'record';
}

/** @public */
export declare interface TLHistoryDiff<R extends UnknownRecord> {
    type: 'diff';
    diff: RecordsDiff<R>;
}

/** @public */
export declare type TLHistoryEntry<R extends UnknownRecord> = TLHistoryDiff<R> | TLHistoryMark;

/** @public */
export declare interface TLHistoryMark {
    type: 'stop';
    id: string;
}

/** @public */
export declare type TLInterruptEvent = (info: TLInterruptEventInfo) => void;

/** @public */
export declare interface TLInterruptEventInfo {
    type: 'misc';
    name: 'interrupt';
}

/** @public */
export declare type TLKeyboardEvent = (info: TLKeyboardEventInfo) => void;

/** @public */
export declare type TLKeyboardEventInfo = TLBaseEventInfo & {
    code: string;
    key: string;
    name: TLKeyboardEventName;
    type: 'keyboard';
};

/** @public */
export declare type TLKeyboardEventName = 'key_down' | 'key_repeat' | 'key_up';

/** @public */
export declare interface TLMeasureTextSpanOpts {
    overflow: 'truncate-clip' | 'truncate-ellipsis' | 'wrap';
    width: number;
    height: number;
    padding: number;
    fontSize: number;
    fontWeight: string;
    fontFamily: string;
    fontStyle: string;
    lineHeight: number;
    textAlign: TLDefaultHorizontalAlignStyle;
}

/** @public */
export declare type TLOnBeforeCreateHandler<T extends TLShape> = (next: T) => T | void;

/** @public */
export declare type TLOnBeforeUpdateHandler<T extends TLShape> = (prev: T, next: T) => T | void;

/* Excluded from this release type: TLOnBindingChangeHandler */

/** @public */
export declare type TLOnChildrenChangeHandler<T extends TLShape> = (shape: T) => TLShapePartial[] | void;

/** @public */
export declare type TLOnClickHandler<T extends TLShape> = (shape: T) => TLShapePartial<T> | void;

/** @public */
export declare type TLOnDoubleClickHandleHandler<T extends TLShape> = (shape: T, handle: TLHandle) => TLShapePartial<T> | void;

/** @public */
export declare type TLOnDoubleClickHandler<T extends TLShape> = (shape: T) => TLShapePartial<T> | void;

/** @public */
export declare type TLOnDragHandler<T extends TLShape, R = void> = (shape: T, shapes: TLShape[]) => R;

/** @public */
export declare type TLOnEditEndHandler<T extends TLShape> = (shape: T) => void;

/** @public */
export declare type TLOnHandleDragHandler<T extends TLShape> = (shape: T, info: {
    handle: TLHandle;
    initial?: T | undefined;
    isPrecise: boolean;
}) => TLShapePartial<T> | void;

/**
 * Called when the editor has mounted.
 * @example
 * ```ts
 * <Tldraw onMount={(editor) => editor.selectAll()} />
 * ```
 * @param editor - The editor instance.
 *
 * @public
 */
export declare type TLOnMountHandler = (editor: Editor) => (() => undefined | void) | undefined | void;

/** @public */
export declare type TLOnResizeEndHandler<T extends TLShape> = (initial: T, current: T) => TLShapePartial<T> | void;

/** @public */
export declare type TLOnResizeHandler<T extends TLShape> = (shape: T, info: TLResizeInfo<T>) => Omit<TLShapePartial<T>, 'id' | 'type'> | undefined | void;

/** @public */
export declare type TLOnResizeStartHandler<T extends TLShape> = (shape: T) => TLShapePartial<T> | void;

/** @public */
export declare type TLOnRotateEndHandler<T extends TLShape> = (initial: T, current: T) => TLShapePartial<T> | void;

/** @public */
export declare type TLOnRotateHandler<T extends TLShape> = (initial: T, current: T) => TLShapePartial<T> | void;

/** @public */
export declare type TLOnRotateStartHandler<T extends TLShape> = (shape: T) => TLShapePartial<T> | void;

/** @public */
export declare type TLOnTranslateEndHandler<T extends TLShape> = (initial: T, current: T) => TLShapePartial<T> | void;

/** @public */
export declare type TLOnTranslateHandler<T extends TLShape> = (initial: T, current: T) => TLShapePartial<T> | void;

/** @public */
export declare type TLOnTranslateStartHandler<T extends TLShape> = (shape: T) => TLShapePartial<T> | void;

/** @public */
export declare type TLPinchEvent = (info: TLPinchEventInfo) => void;

/** @public */
export declare type TLPinchEventInfo = TLBaseEventInfo & {
    delta: VecModel;
    name: TLPinchEventName;
    point: VecModel;
    type: 'pinch';
};

/** @public */
export declare type TLPinchEventName = 'pinch_end' | 'pinch_start' | 'pinch';

/** @public */
export declare type TLPointerEvent = (info: TLPointerEventInfo) => void;

/** @public */
export declare type TLPointerEventInfo = TLBaseEventInfo & {
    button: number;
    isPen: boolean;
    name: TLPointerEventName;
    point: VecLike;
    pointerId: number;
    type: 'pointer';
} & TLPointerEventTarget;

/** @public */
export declare type TLPointerEventName = 'long_press' | 'middle_click' | 'pointer_down' | 'pointer_move' | 'pointer_up' | 'right_click';

/** @public */
export declare type TLPointerEventTarget = {
    handle: TLHandle;
    shape: TLShape;
    target: 'handle';
} | {
    handle?: TLSelectionHandle;
    shape?: undefined;
    target: 'selection';
} | {
    shape: TLShape;
    target: 'shape';
} | {
    shape?: undefined;
    target: 'canvas';
};

/** @public */
export declare type TLResizeHandle = SelectionCorner | SelectionEdge;

/**
 * Info about a resize.
 * @param newPoint - The new local position of the shape.
 * @param handle - The handle being dragged.
 * @param mode - The type of resize.
 * @param scaleX - The scale in the x-axis.
 * @param scaleY - The scale in the y-axis.
 * @param initialBounds - The bounds of the shape at the start of the resize.
 * @param initialShape - The shape at the start of the resize.
 * @public
 */
export declare interface TLResizeInfo<T extends TLShape> {
    newPoint: Vec;
    handle: TLResizeHandle;
    mode: TLResizeMode;
    scaleX: number;
    scaleY: number;
    initialBounds: Box;
    initialShape: T;
}

/**
 * The type of resize.
 *
 * 'scale_shape' - The shape is being scaled, usually as part of a larger selection.
 *
 * 'resize_bounds' - The user is directly manipulating an individual shape's bounds using a resize
 * handle. It is up to shape util implementers to decide how they want to handle the two
 * situations.
 *
 * @public
 */
export declare type TLResizeMode = 'resize_bounds' | 'scale_shape';

/** @public */
export declare type TLResizeShapeOptions = Partial<{
    dragHandle: TLResizeHandle;
    initialBounds: Box;
    initialPageTransform: MatLike;
    initialShape: TLShape;
    isAspectRatioLocked: boolean;
    mode: TLResizeMode;
    scaleAxisRotation: number;
    scaleOrigin: VecLike;
    skipStartAndEndCallbacks: boolean;
}>;

/**
 * Info about a rotation that can be applied to the editor's selected shapes.
 *
 * @param selectionPageCenter - The center of the selection in page coordinates
 * @param initialCursorAngle - The angle of the cursor relative to the selection center when the rotation started
 * @param initialSelectionRotation - The rotation of the selection when the rotation started
 * @param shapeSnapshots - Info about each shape that is being rotated
 *
 * @public
 **/
export declare interface TLRotationSnapshot {
    selectionPageCenter: Vec;
    initialCursorAngle: number;
    initialSelectionRotation: number;
    shapeSnapshots: {
        initialPagePoint: Vec;
        shape: TLShape;
    }[];
}

/** @public */
export declare interface TLScribbleProps {
    scribble: TLScribble;
    zoom: number;
    color?: string;
    opacity?: number;
    className?: string;
}

/** @public */
export declare interface TLSelectionBackgroundProps {
    bounds: Box;
    rotation: number;
}

/** @public */
export declare interface TLSelectionForegroundProps {
    bounds: Box;
    rotation: number;
}

/** @public */
export declare type TLSelectionHandle = RotateCorner | SelectionCorner | SelectionEdge;

/**
 * The state of the editor instance, not including any document state.
 *
 * @public
 */
export declare interface TLSessionStateSnapshot {
    version: number;
    currentPageId: TLPageId;
    isFocusMode: boolean;
    exportBackground: boolean;
    isDebugMode: boolean;
    isToolLocked: boolean;
    isGridMode: boolean;
    pageStates: Array<{
        camera: {
            x: number;
            y: number;
            z: number;
        };
        focusedGroupId: null | TLShapeId;
        pageId: TLPageId;
        selectedShapeIds: TLShapeId[];
    }>;
}

/** @public */
export declare type TLShapeErrorFallbackComponent = ComponentType<{
    error: any;
}>;

/** @public */
export declare type TLShapeIndicatorErrorFallbackComponent = ComponentType<{
    error: unknown;
}>;

/** @public */
export declare interface TLShapeIndicatorProps {
    shapeId: TLShapeId;
    color?: string | undefined;
    opacity?: number;
    className?: string;
    hidden?: boolean;
}

/**
 * Options passed to {@link ShapeUtil.canBind}. A binding that could be made. At least one of
 * `fromShapeType` or `toShapeType` will belong to this shape util.
 *
 * @public
 */
export declare interface TLShapeUtilCanBindOpts<Shape extends TLUnknownShape = TLShape> {
    /** The type of shape referenced by the `fromId` of the binding. */
    fromShapeType: string;
    /** The type of shape referenced by the `toId` of the binding. */
    toShapeType: string;
    /** The type of binding. */
    bindingType: string;
}

/** @public */
export declare interface TLShapeUtilCanvasSvgDef {
    key: string;
    component: React.ComponentType;
}

/** @public */
export declare interface TLShapeUtilConstructor<T extends TLUnknownShape, U extends ShapeUtil<T> = ShapeUtil<T>> {
    new (editor: Editor): U;
    type: T['type'];
    props?: RecordProps<T>;
    migrations?: LegacyMigrations | MigrationSequence | TLPropsMigrations;
}

/** @public */
export declare type TLShapeUtilFlag<T> = (shape: T) => boolean;

/** @public */
export declare interface TLSnapIndicatorProps {
    className?: string;
    line: SnapIndicator;
    zoom: number;
}

/** @public */
export declare interface TLStateNodeConstructor {
    new (editor: Editor, parent?: StateNode): StateNode;
    id: string;
    initial?: string;
    children?: () => TLStateNodeConstructor[];
    isLockable: boolean;
}

/** @public */
export declare interface TLStoreBaseOptions {
    /** The initial data for the store. */
    initialData?: SerializedStore<TLRecord>;
    /** A snapshot of initial data to migrate and load into the store. */
    snapshot?: Partial<TLEditorSnapshot> | TLStoreSnapshot;
    /** The default name for the store. */
    defaultName?: string;
    /** How should this store upload & resolve assets? */
    assets?: TLAssetStore;
    /** Called when the store is connected to an {@link Editor}. */
    onMount?(editor: Editor): (() => void) | void;
}

/** @public */
export declare type TLStoreEventInfo = HistoryEntry<TLRecord>;

/** @public */
export declare type TLStoreOptions = TLStoreBaseOptions & {
    /** Collaboration options for the store. */
    collaboration?: {
        status: null | Signal<'offline' | 'online'>;
    };
    id?: string;
} & TLStoreSchemaOptions;

/** @public */
export declare type TLStoreSchemaOptions = {
    bindingUtils?: readonly TLAnyBindingUtilConstructor[];
    migrations?: readonly MigrationSequence[];
    shapeUtils?: readonly TLAnyShapeUtilConstructor[];
} | {
    schema?: StoreSchema<TLRecord, TLStoreProps>;
};

/** @public */
export declare type TLStoreWithStatus = {
    readonly connectionStatus: 'offline' | 'online';
    readonly error?: undefined;
    readonly status: 'synced-remote';
    readonly store: TLStore;
} | {
    readonly error: Error;
    readonly status: 'error';
    readonly store?: undefined;
} | {
    readonly error?: undefined;
    readonly status: 'loading';
    readonly store?: undefined;
} | {
    readonly error?: undefined;
    readonly status: 'not-synced';
    readonly store: TLStore;
} | {
    readonly error?: undefined;
    readonly status: 'synced-local';
    readonly store: TLStore;
};

/** @public */
export declare interface TLSvgOptions {
    bounds?: Box;
    scale?: number;
    background?: boolean;
    padding?: number;
    darkMode?: boolean;
    preserveAspectRatio?: React.SVGAttributes<SVGSVGElement>['preserveAspectRatio'];
}

/** @public */
export declare type TLTickEvent = (info: TLTickEventInfo) => void;

/** @public */
export declare interface TLTickEventInfo {
    type: 'misc';
    name: 'tick';
    elapsed: number;
}

/** @public */
export declare interface TLUser {
    readonly userPreferences: Signal<TLUserPreferences>;
    readonly setUserPreferences: (userPreferences: TLUserPreferences) => void;
}

/**
 * A user of tldraw
 *
 * @public
 */
export declare interface TLUserPreferences {
    id: string;
    name?: null | string;
    locale?: null | string;
    color?: null | string;
    animationSpeed?: null | number;
    edgeScrollSpeed?: null | number;
    colorScheme?: 'dark' | 'light' | 'system';
    isSnapMode?: boolean | null;
    isWrapMode?: boolean | null;
    isDynamicSizeMode?: boolean | null;
    isPasteAtCursorMode?: boolean | null;
}

/** @public */
export declare type TLWheelEvent = (info: TLWheelEventInfo) => void;

/** @public */
export declare type TLWheelEventInfo = TLBaseEventInfo & {
    delta: VecModel;
    name: 'wheel';
    point: VecModel;
    type: 'wheel';
};

/**
 * The DOM likes values to be fixed to 3 decimal places
 *
 * @public
 */
export declare function toDomPrecision(v: number): number;

/**
 * @public
 */
export declare function toFixed(v: number): number;

/**
 * Get a number to a precision.
 *
 * @param n - The number.
 * @param precision - The precision.
 * @public
 */
export declare function toPrecision(n: number, precision?: number): number;

export { track }

export { transact }

export { transaction }

/** @public */
export declare type UiEvent = TLCancelEvent | TLClickEvent | TLCompleteEvent | TLKeyboardEvent | TLPinchEvent | TLPointerEvent;

/** @public */
export declare type UiEventType = 'click' | 'keyboard' | 'pinch' | 'pointer' | 'wheel' | 'zoom';

/** @public */
export declare function uniq<T>(array: {
    readonly [n: number]: T;
    readonly length: number;
} | null | undefined): T[];

/**
 * Generate a unique id.
 *
 * @example
 *
 * ```ts
 * const id = uniqueId()
 * ```
 *
 * @public
 */
export declare function uniqueId(): string;

export { useComputed }

/** @public */
export declare function useContainer(): HTMLDivElement;

/** @public */
export declare function useEditor(): Editor;

/** @public */
export declare function useEditorComponents(): Required<TLEditorComponents>;

/* Excluded from this release type: useEvent */

/** @public */
export declare function useIsCropping(shapeId: TLShapeId): boolean;

/** @public */
export declare function useIsDarkMode(): boolean;

/** @public */
export declare function useIsEditing(shapeId: TLShapeId): boolean;

/* Excluded from this release type: useLocalStore */

/* Excluded from this release type: useOnMount */

/* Excluded from this release type: usePeerIds */

/* Excluded from this release type: usePresence */
export { useQuickReactor }

/* Excluded from this release type: USER_COLORS */
export { useReactor }

/* Excluded from this release type: useRefState */

/** @public */
export declare class UserPreferencesManager {
    private readonly user;
    private readonly inferDarkMode;
    systemColorScheme: Atom<"dark" | "light", unknown>;
    constructor(user: TLUser, inferDarkMode: boolean);
    updateUserPreferences: (userPreferences: Partial<TLUserPreferences>) => void;
    getUserPreferences(): {
        animationSpeed: number;
        color: string;
        colorScheme: "dark" | "light" | "system" | undefined;
        id: string;
        isDarkMode: boolean;
        isDynamicResizeMode: boolean;
        isSnapMode: boolean;
        isWrapMode: boolean;
        locale: string;
        name: string;
    };
    getIsDarkMode(): boolean;
    /**
     * The speed at which the user can scroll by dragging toward the edge of the screen.
     */
    getEdgeScrollSpeed(): number;
    getAnimationSpeed(): number;
    getId(): string;
    getName(): string;
    getLocale(): string;
    getColor(): string;
    getIsSnapMode(): boolean;
    getIsWrapMode(): boolean;
    getIsDynamicResizeMode(): boolean;
    getIsPasteAtCursorMode(): boolean;
}

/* Excluded from this release type: useSafeId */

/** @public */
export declare function useSelectionEvents(handle: TLSelectionHandle): {
    onPointerDown: PointerEventHandler<Element>;
    onPointerMove: (e: React.PointerEvent) => void;
    onPointerUp: PointerEventHandler<Element>;
};

/* Excluded from this release type: useShallowArrayIdentity */

/* Excluded from this release type: useShallowObjectIdentity */
export { useStateTracking }

/**
 * Returns the read-only parts of {@link SvgExportContext}.
 * @public
 */
export declare function useSvgExportContext(): {
    isDarkMode: boolean;
} | null;

/**
 * @public
 */
export declare function useTldrawUser(opts: {
    setUserPreferences?: (userPreferences: TLUserPreferences) => void;
    userPreferences?: Signal<TLUserPreferences> | TLUserPreferences;
}): TLUser;

/** @public */
export declare function useTLSchemaFromUtils(opts: TLStoreSchemaOptions): StoreSchema<TLRecord, TLStoreProps>;

/** @public */
export declare function useTLStore(opts: TLStoreOptions): TLStore;

/** @public */
export declare function useTransform(ref: React.RefObject<HTMLElement | SVGElement>, x?: number, y?: number, scale?: number, rotate?: number, additionalOffset?: VecLike): void;

export { useValue }

/** @public */
export declare class Vec {
    x: number;
    y: number;
    z: number;
    constructor(x?: number, y?: number, z?: number);
    get pressure(): number;
    set(x?: number, y?: number, z?: number): this;
    setTo({ x, y, z }: VecLike): this;
    rot(r: number): this;
    rotWith(C: VecLike, r: number): this;
    clone(): Vec;
    sub(V: VecLike): this;
    subXY(x: number, y: number): this;
    subScalar(n: number): this;
    add(V: VecLike): this;
    addXY(x: number, y: number): this;
    addScalar(n: number): this;
    clamp(min: number, max?: number): this;
    div(t: number): this;
    divV(V: VecLike): this;
    mul(t: number): this;
    mulV(V: VecLike): this;
    abs(): this;
    nudge(B: VecLike, distance: number): this;
    neg(): this;
    cross(V: VecLike): this;
    dpr(V: VecLike): number;
    cpr(V: VecLike): number;
    len2(): number;
    len(): number;
    pry(V: VecLike): number;
    per(): this;
    uni(): Vec;
    tan(V: VecLike): Vec;
    dist(V: VecLike): number;
    distanceToLineSegment(A: VecLike, B: VecLike): number;
    slope(B: VecLike): number;
    snapToGrid(gridSize: number): this;
    angle(B: VecLike): number;
    toAngle(): number;
    lrp(B: VecLike, t: number): Vec;
    equals(B: VecLike): boolean;
    equalsXY(x: number, y: number): boolean;
    norm(): this;
    toFixed(): Vec;
    toString(): string;
    toJson(): VecModel;
    toArray(): number[];
    static Add(A: VecLike, B: VecLike): Vec;
    static AddXY(A: VecLike, x: number, y: number): Vec;
    static Sub(A: VecLike, B: VecLike): Vec;
    static SubXY(A: VecLike, x: number, y: number): Vec;
    static AddScalar(A: VecLike, n: number): Vec;
    static SubScalar(A: VecLike, n: number): Vec;
    static Div(A: VecLike, t: number): Vec;
    static Mul(A: VecLike, t: number): Vec;
    static DivV(A: VecLike, B: VecLike): Vec;
    static MulV(A: VecLike, B: VecLike): Vec;
    static Neg(A: VecLike): Vec;
    /**
     * Get the perpendicular vector to A.
     */
    static Per(A: VecLike): Vec;
    static Abs(A: VecLike): Vec;
    static Dist(A: VecLike, B: VecLike): number;
    static DistMin(A: VecLike, B: VecLike, n: number): boolean;
    static Dist2(A: VecLike, B: VecLike): number;
    /**
     * Dot product of two vectors which is used to calculate the angle between them.
     */
    static Dpr(A: VecLike, B: VecLike): number;
    static Cross(A: VecLike, V: VecLike): Vec;
    /**
     * Cross product of two vectors which is used to calculate the area of a parallelogram.
     */
    static Cpr(A: VecLike, B: VecLike): number;
    static Len2(A: VecLike): number;
    static Len(A: VecLike): number;
    /**
     * Get the projection of A onto B.
     */
    static Pry(A: VecLike, B: VecLike): number;
    /**
     * Get the unit vector of A.
     */
    static Uni(A: VecLike): Vec;
    static Tan(A: VecLike, B: VecLike): Vec;
    static Min(A: VecLike, B: VecLike): Vec;
    static Max(A: VecLike, B: VecLike): Vec;
    static From({ x, y, z }: VecModel): Vec;
    static FromArray(v: number[]): Vec;
    static Rot(A: VecLike, r?: number): Vec;
    static RotWith(A: VecLike, C: VecLike, r: number): Vec;
    /**
     * Get the nearest point on a line with a known unit vector that passes through point A
     *
     * ```ts
     * Vec.nearestPointOnLineThroughPoint(A, u, Point)
     * ```
     *
     * @param A - Any point on the line
     * @param u - The unit vector for the line.
     * @param P - A point not on the line to test.
     */
    static NearestPointOnLineThroughPoint(A: VecLike, u: VecLike, P: VecLike): Vec;
    static NearestPointOnLineSegment(A: VecLike, B: VecLike, P: VecLike, clamp?: boolean): Vec;
    static DistanceToLineThroughPoint(A: VecLike, u: VecLike, P: VecLike): number;
    static DistanceToLineSegment(A: VecLike, B: VecLike, P: VecLike, clamp?: boolean): number;
    static Snap(A: VecLike, step?: number): Vec;
    static Cast(A: VecLike): Vec;
    static Slope(A: VecLike, B: VecLike): number;
    static IsNaN(A: VecLike): boolean;
    static Angle(A: VecLike, B: VecLike): number;
    /**
     * Linearly interpolate between two points.
     * @param A - The first point.
     * @param B - The second point.
     * @param t - The interpolation value between 0 and 1.
     * @returns The interpolated point.
     */
    static Lrp(A: VecLike, B: VecLike, t: number): Vec;
    static Med(A: VecLike, B: VecLike): Vec;
    static Equals(A: VecLike, B: VecLike): boolean;
    static EqualsXY(A: VecLike, x: number, y: number): boolean;
    static Clockwise(A: VecLike, B: VecLike, C: VecLike): boolean;
    static Rescale(A: VecLike, n: number): Vec;
    static ScaleWithOrigin(A: VecLike, scale: number, origin: VecLike): Vec;
    static ToFixed(A: VecLike): Vec;
    static ToInt(A: VecLike): Vec;
    static ToCss(A: VecLike): string;
    static Nudge(A: VecLike, B: VecLike, distance: number): Vec;
    static ToString(A: VecLike): string;
    static ToAngle(A: VecLike): number;
    static FromAngle(r: number, length?: number): Vec;
    static ToArray(A: VecLike): number[];
    static ToJson(A: VecLike): {
        x: number;
        y: number;
        z: number | undefined;
    };
    static Average(arr: VecLike[]): Vec;
    static Clamp(A: Vec, min: number, max?: number): Vec;
    /**
     * Get an array of points (with simulated pressure) between two points.
     *
     * @param A - The first point.
     * @param B - The second point.
     * @param steps - The number of points to return.
     */
    static PointsBetween(A: VecModel, B: VecModel, steps?: number): Vec[];
    static SnapToGrid(A: VecLike, gridSize?: number): Vec;
}

/** @public */
export declare type VecLike = Vec | VecModel;

export { whyAmIRunning }


export * from "@tldraw/store";
export * from "@tldraw/tlschema";
export * from "@tldraw/utils";
export * from "@tldraw/validate";

export { }
